/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.kafka;

import ch.admin.bit.jeap.messaging.kafka.contract.ContractsValidator;
import ch.admin.bit.jeap.messaging.model.MessageType;
import ch.admin.bit.jeap.processarchive.domain.archive.event.ArchivedArtifactCreatedEventProducer;
import ch.admin.bit.jeap.processarchive.kafka.event.ArchivedArtifactEventProperties;
import ch.admin.bit.jeap.processarchive.kafka.event.ArchivedArtifactVersionCreatedEventBuilder;
import ch.admin.bit.jeap.processarchive.kafka.event.ArchivedArtifactVersionCreatedEventFactory;
import ch.admin.bit.jeap.processarchive.kafka.event.KafkaArchivedArtifactCreatedEventProducer;
import ch.admin.bit.jeap.processarchive.kafka.event.ProcessArchiveEventPublisher;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedartifact.ArchivedArtifact;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.PropertySource;

@AutoConfiguration
@ComponentScan
@PropertySource(value={"classpath:process-archive-kafka-defaults.properties"})
@EnableConfigurationProperties(value={ArchivedArtifactEventProperties.class})
class KafkaAdapterConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaAdapterConfig.class);
    private final ContractsValidator contractsValidator;
    private final ArchivedArtifactEventProperties eventProperties;

    @PostConstruct
    void validate() {
        if (this.eventProperties.isEnabled()) {
            this.contractsValidator.ensurePublisherContract((MessageType)ArchivedArtifactVersionCreatedEventBuilder.messageType(), this.eventProperties.getEventTopic());
        }
    }

    @Bean
    @ConditionalOnProperty(value={"jeap.processarchive.archivedartifact.enabled"}, havingValue="true", matchIfMissing=true)
    KafkaArchivedArtifactCreatedEventProducer kafkaArchivedArtifactCreatedEventProducer(ProcessArchiveEventPublisher eventPublisher, ArchivedArtifactVersionCreatedEventFactory eventFactory) {
        return new KafkaArchivedArtifactCreatedEventProducer(eventPublisher, eventFactory);
    }

    @Bean
    @ConditionalOnProperty(value={"jeap.processarchive.archivedartifact.enabled"}, havingValue="false")
    ArchivedArtifactCreatedEventProducer noOpArchivedArtifactCreatedEventProducer() {
        return new ArchivedArtifactCreatedEventProducer(this){

            public void onArchivedArtifact(ArchivedArtifact archivedArtifact) {
            }
        };
    }

    @Generated
    public KafkaAdapterConfig(ContractsValidator contractsValidator, ArchivedArtifactEventProperties eventProperties) {
        this.contractsValidator = contractsValidator;
        this.eventProperties = eventProperties;
    }
}

