/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.avro.repository;

import ch.admin.bit.jeap.processarchive.avro.plugin.compiler.IdlFileParser;
import ch.admin.bit.jeap.processarchive.avro.plugin.compiler.ImportClassLoader;
import ch.admin.bit.jeap.processarchive.avro.plugin.registry.connector.ArchiveTypeDescriptor;
import ch.admin.bit.jeap.processarchive.avro.plugin.registry.connector.ArchiveTypeVersion;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveResourceUtils;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveType;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeEncryption;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeEncryptionKey;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeId;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeLoaderException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.idl.ParseException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ArchiveTypeLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArchiveTypeLoader.class);
    private static final String RESOURCE_PATH = "/archive-types";
    private static final int MAX_DESCRIPTOR_SEARCH_DEPTH = 5;
    private final ObjectMapper objectMapper;
    private final Map<Path, ImportClassLoader> importClassLoadersPerSystem = new HashMap<Path, ImportClassLoader>();

    ArchiveTypeLoader() {
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<ArchiveTypeId, ArchiveType> loadArchiveTypes() throws IOException {
        Path targetRoot = Files.createTempDirectory(this.getClass().getSimpleName(), new FileAttribute[0]);
        try {
            ArchiveResourceUtils.copyFromClassPath(RESOURCE_PATH, targetRoot);
            HashMap<ArchiveTypeId, ArchiveType> archiveTypes = new HashMap<ArchiveTypeId, ArchiveType>();
            Files.find(targetRoot, 5, (path, attrs) -> path.getFileName().toString().endsWith(".json") && Files.isRegularFile(path, new LinkOption[0]), new FileVisitOption[0]).forEach(descriptorPath -> this.loadArchiveTypeFromDescriptor((Path)descriptorPath, (Map<ArchiveTypeId, ArchiveType>)archiveTypes));
            HashMap<ArchiveTypeId, ArchiveType> hashMap = archiveTypes;
            return hashMap;
        }
        finally {
            FileUtils.deleteQuietly((File)targetRoot.toFile());
        }
    }

    private void loadArchiveTypeFromDescriptor(Path descriptorPath, Map<ArchiveTypeId, ArchiveType> archiveTypes) {
        log.info("Reading archive type descriptor {}", (Object)descriptorPath);
        ArchiveTypeDescriptor archiveTypeDescriptor = this.parseDescriptor(descriptorPath);
        Path systemDir = descriptorPath.getParent();
        archiveTypeDescriptor.getVersions().forEach(v -> this.loadArchiveTypeVersion((ArchiveTypeVersion)v, archiveTypeDescriptor, systemDir, archiveTypes));
    }

    private ArchiveTypeDescriptor parseDescriptor(Path descriptorPath) {
        try {
            return (ArchiveTypeDescriptor)this.objectMapper.readValue(descriptorPath.toFile(), ArchiveTypeDescriptor.class);
        }
        catch (IOException e) {
            throw ArchiveTypeLoaderException.jsonParsingFailed(descriptorPath, e);
        }
    }

    private void loadArchiveTypeVersion(ArchiveTypeVersion version, ArchiveTypeDescriptor archiveTypeDescriptor, Path descriptorDir, Map<ArchiveTypeId, ArchiveType> schemas) {
        String archiveTypeName = archiveTypeDescriptor.getArchiveType();
        ArchiveTypeId archiveTypeId = ArchiveTypeId.builder().system(archiveTypeDescriptor.getSystem()).name(archiveTypeName).version(version.getVersion()).build();
        Path schemaFile = this.getSchemaFile(descriptorDir, version.getSchema());
        log.info("Loading schema for archive type {} version {} for system {} from schema file {}", new Object[]{archiveTypeId.getName(), archiveTypeId.getVersion(), archiveTypeId.getSystem(), schemaFile});
        Schema schema = this.loadSchema(descriptorDir, archiveTypeName, schemaFile);
        ArchiveType archiveType = ArchiveType.builder().name(archiveTypeName).system(archiveTypeDescriptor.getSystem()).referenceIdType(archiveTypeDescriptor.getReferenceIdType()).version(version.getVersion()).schema(schema).expirationDays(archiveTypeDescriptor.getExpirationDays()).encryption(this.getArchiveTypeEncryptionFromDescriptor(archiveTypeDescriptor)).encryptionKey(this.getArchiveTypeEncryptionKeyFromDescriptor(archiveTypeDescriptor)).build();
        schemas.put(archiveTypeId, archiveType);
    }

    private ArchiveTypeEncryption getArchiveTypeEncryptionFromDescriptor(ArchiveTypeDescriptor archiveTypeDescriptor) {
        if (archiveTypeDescriptor.getEncryption() != null) {
            return ArchiveTypeEncryption.builder().secretEnginePath(archiveTypeDescriptor.getEncryption().getSecretEnginePath()).keyName(archiveTypeDescriptor.getEncryption().getKeyName()).build();
        }
        return null;
    }

    private ArchiveTypeEncryptionKey getArchiveTypeEncryptionKeyFromDescriptor(ArchiveTypeDescriptor archiveTypeDescriptor) {
        if (archiveTypeDescriptor.getEncryptionKey() != null) {
            return ArchiveTypeEncryptionKey.builder().keyId(archiveTypeDescriptor.getEncryptionKey().getKeyId()).build();
        }
        return null;
    }

    private Schema loadSchema(Path descriptorDir, String archiveType, Path schemaFile) {
        Path systemDir = descriptorDir.getParent();
        ImportClassLoader importClassLoader = this.getOrCreateSystemImportClassLoader(systemDir);
        IdlFileParser idlFileParser = new IdlFileParser(importClassLoader);
        try {
            Protocol protocol = idlFileParser.parseIdlFile(schemaFile.toFile());
            return protocol.getType(protocol.getNamespace() + "." + archiveType);
        }
        catch (IOException | ParseException e) {
            throw ArchiveTypeLoaderException.avroSchemaParsingFailed(schemaFile, (Exception)e);
        }
    }

    private ImportClassLoader getOrCreateSystemImportClassLoader(Path systemDir) {
        return this.importClassLoadersPerSystem.computeIfAbsent(systemDir, ArchiveTypeLoader::createImportClassLoader);
    }

    private static ImportClassLoader createImportClassLoader(Path systemDir) {
        Path commonRootDir = systemDir.getParent().resolve("_common");
        Path commonSystemDir = systemDir.resolve("_common");
        return new ImportClassLoader(Thread.currentThread().getContextClassLoader(), commonRootDir.toFile(), commonSystemDir.toFile());
    }

    private Path getSchemaFile(Path descriptorDir, String filename) {
        Path inArchiveTypeDir = descriptorDir.resolve(filename);
        if (Files.isRegularFile(inArchiveTypeDir, new LinkOption[0])) {
            return inArchiveTypeDir;
        }
        Path systemDir = descriptorDir.getParent();
        Path inCommonSystemDir = systemDir.resolve("_common").resolve(filename);
        if (Files.isRegularFile(inCommonSystemDir, new LinkOption[0])) {
            return inCommonSystemDir;
        }
        Path inCommonRootDir = systemDir.getParent().resolve("_common").resolve(filename);
        if (Files.isRegularFile(inCommonRootDir, new LinkOption[0])) {
            return inCommonRootDir;
        }
        throw ArchiveTypeLoaderException.schemaFileNotFound(descriptorDir, filename);
    }
}

