/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.avro.repository;

import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeId;
import java.io.IOException;
import java.nio.file.Path;

public class ArchiveTypeLoaderException
extends RuntimeException {
    private ArchiveTypeLoaderException(String message) {
        super(message);
    }

    private ArchiveTypeLoaderException(String message, Exception exception) {
        super(message, exception);
    }

    static ArchiveTypeLoaderException jsonParsingFailed(Path descriptorPath, IOException e) {
        return new ArchiveTypeLoaderException("Failed to load descriptor at " + String.valueOf(descriptorPath), e);
    }

    static ArchiveTypeLoaderException schemaFileNotFound(Path descriptorDir, String filename) {
        return new ArchiveTypeLoaderException(String.format("Schema file %s referenced in descriptor %s not found", filename, descriptorDir));
    }

    static ArchiveTypeLoaderException avroSchemaParsingFailed(Path schemaFile, Exception exception) {
        return new ArchiveTypeLoaderException("Failed to parse schema file " + String.valueOf(schemaFile), exception);
    }

    static ArchiveTypeLoaderException archiveTypeNotFound(ArchiveTypeId archiveTypeId) {
        return new ArchiveTypeLoaderException("Archive type unknown: " + String.valueOf(archiveTypeId));
    }
}

