/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.avro;

import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveType;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeEncryption;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeEncryptionKey;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeId;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeRepository;
import ch.admin.bit.jeap.processarchive.domain.archive.schema.ArchiveDataSchemaValidator;
import ch.admin.bit.jeap.processarchive.domain.archive.schema.SchemaValidationException;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedata.ArchiveData;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedata.schema.ArchiveDataSchema;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedata.schema.EncryptionKeyId;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedata.schema.EncryptionKeyReference;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import lombok.Generated;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.ValidatingDecoder;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=0)
@Component
public class ArchiveDataAvroSchemaValidator
implements ArchiveDataSchemaValidator {
    private final ArchiveTypeRepository repository;

    public Set<String> getContentTypes() {
        return Set.of("avro/binary");
    }

    public ArchiveDataSchema validatePayloadConformsToSchema(ArchiveData archiveData) {
        ArchiveTypeId schemaId = ArchiveTypeId.builder().system(archiveData.getSystem()).name(archiveData.getSchema()).version(archiveData.getSchemaVersion()).build();
        ArchiveType archiveType = this.repository.requireArchiveType(schemaId);
        this.validateConformsToSchema(archiveData, archiveType.getSchema());
        return this.createArchiveDataSchema(archiveData, archiveType);
    }

    private ArchiveDataSchema createArchiveDataSchema(ArchiveData archiveData, ArchiveType archiveType) {
        boolean pretty = true;
        String avroProtocol = archiveType.getSchema().toString(pretty);
        return ArchiveDataSchema.builder().system(archiveData.getSystem()).name(archiveData.getSchema()).referenceIdType(archiveType.getReferenceIdType()).version(archiveData.getSchemaVersion()).fileExtension("avpr").schemaDefinition(avroProtocol.getBytes(StandardCharsets.UTF_8)).expirationDays(archiveType.getExpirationDays().intValue()).encryptionKeyReference(this.getEncryptionKeyReferenceFromArchiveType(archiveType.getEncryption())).encryptionKeyId(this.getEncryptionKeyIdReferenceFromArchiveType(archiveType.getEncryptionKey())).build();
    }

    private EncryptionKeyReference getEncryptionKeyReferenceFromArchiveType(ArchiveTypeEncryption encryption) {
        if (encryption != null) {
            return EncryptionKeyReference.builder().keyName(encryption.getKeyName()).secretEnginePath(encryption.getSecretEnginePath()).build();
        }
        return null;
    }

    private EncryptionKeyId getEncryptionKeyIdReferenceFromArchiveType(ArchiveTypeEncryptionKey encryption) {
        if (encryption != null) {
            return EncryptionKeyId.builder().keyId(encryption.getKeyId()).build();
        }
        return null;
    }

    private void validateConformsToSchema(ArchiveData archiveData, Schema schema) {
        byte[] payload = archiveData.getPayload();
        GenericDatumReader reader = new GenericDatumReader(schema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(payload, null);
        try {
            ValidatingDecoder validatingDecoder = DecoderFactory.get().validatingDecoder(schema, (Decoder)decoder);
            reader.read(null, (Decoder)validatingDecoder);
        }
        catch (Exception ex) {
            throw SchemaValidationException.schemaValidationFailed((ArchiveData)archiveData, (Exception)ex);
        }
    }

    @Generated
    public ArchiveDataAvroSchemaValidator(ArchiveTypeRepository repository) {
        this.repository = repository;
    }
}

