/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.avro.repository;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class ArchiveResourceUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArchiveResourceUtils.class);

    private ArchiveResourceUtils() {
    }

    public static void copyFromClassPath(String resourcePath, Path targetRoot) {
        try {
            Resource[] resources;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (Resource resource : resources = resolver.getResources("classpath*:" + resourcePath + "/**")) {
                if (!resource.exists()) continue;
                String pathOfResource = resource.getURL().getPath();
                int lastIndex = pathOfResource.lastIndexOf(resourcePath);
                if (lastIndex == -1) {
                    log.error("cannot find[{}] from pathOfResource[{}]", (Object)resourcePath, (Object)pathOfResource);
                    continue;
                }
                String relativePath = pathOfResource.substring(lastIndex, pathOfResource.length());
                Path targetPath = Paths.get(targetRoot.toString(), relativePath);
                if (resource.isReadable()) {
                    log.debug("creating file {}", (Object)targetPath);
                    File targetFile = targetPath.toFile();
                    FileUtils.copyURLToFile((URL)resource.getURL(), (File)targetFile);
                    continue;
                }
                log.debug("creating directory {}", (Object)targetPath);
                Files.createDirectories(targetPath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

