/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.avro.repository;

import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveType;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeEncryption;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeEncryptionKey;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeId;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeLoader;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeLoaderException;
import ch.admin.bit.jeap.processarchive.crypto.ArchiveCryptoService;
import ch.admin.bit.jeap.processarchive.crypto.ArchiveDataEncryption;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedata.schema.EncryptionKeyId;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedata.schema.EncryptionKeyReference;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ArchiveTypeRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArchiveTypeRepository.class);
    private final ArchiveTypeLoader archiveTypeLoader;
    private final Map<ArchiveTypeId, ArchiveType> archiveTypes = new ConcurrentHashMap<ArchiveTypeId, ArchiveType>();
    private final ArchiveCryptoService archiveCryptoService;

    @PostConstruct
    void initialize() throws IOException {
        this.archiveTypes.putAll(this.archiveTypeLoader.loadArchiveTypes());
        log.info("Loaded {} archive types: {}", (Object)this.archiveTypes.size(), this.archiveTypes.keySet());
        Set<ArchiveTypeEncryption> encryptions = this.archiveTypes.values().stream().map(ArchiveType::getEncryption).filter(Objects::nonNull).collect(Collectors.toSet());
        this.validateEncryptionConfiguration(encryptions);
        Set<ArchiveTypeEncryptionKey> encryptionKeys = this.archiveTypes.values().stream().map(ArchiveType::getEncryptionKey).filter(Objects::nonNull).collect(Collectors.toSet());
        this.validateEncryptionKeyConfiguration(encryptionKeys);
    }

    private void validateEncryptionConfiguration(Set<ArchiveTypeEncryption> encryptionSet) {
        byte[] payloadToEncrypt = "dummy".getBytes(StandardCharsets.UTF_8);
        for (ArchiveTypeEncryption encryptionConfig : encryptionSet) {
            log.info("Validate encryption configuration {}", (Object)encryptionConfig);
            EncryptionKeyReference keyRef = EncryptionKeyReference.builder().secretEnginePath(encryptionConfig.getSecretEnginePath()).keyName(encryptionConfig.getKeyName()).build();
            ArchiveDataEncryption encryption = ArchiveDataEncryption.builder().encryptionKeyReference(keyRef).build();
            this.archiveCryptoService.encrypt(payloadToEncrypt, encryption);
        }
    }

    private void validateEncryptionKeyConfiguration(Set<ArchiveTypeEncryptionKey> encryptionKeySet) {
        byte[] payloadToEncrypt = "dummy".getBytes(StandardCharsets.UTF_8);
        for (ArchiveTypeEncryptionKey encryptionConfig : encryptionKeySet) {
            log.info("Validate encryption key configuration {}", (Object)encryptionConfig);
            EncryptionKeyId keyId = EncryptionKeyId.builder().keyId(encryptionConfig.getKeyId()).build();
            ArchiveDataEncryption encryption = ArchiveDataEncryption.builder().encryptionKeyId(keyId).build();
            this.archiveCryptoService.encrypt(payloadToEncrypt, encryption);
        }
    }

    public ArchiveType requireArchiveType(ArchiveTypeId archiveTypeId) {
        return this.archiveTypes.computeIfAbsent(archiveTypeId, this::archiveTypeNotFound);
    }

    private ArchiveType archiveTypeNotFound(ArchiveTypeId schemaId) {
        throw ArchiveTypeLoaderException.archiveTypeNotFound(schemaId);
    }

    List<ArchiveType> findAll() {
        ArrayList<ArchiveType> all = new ArrayList<ArchiveType>(this.archiveTypes.values());
        all.sort(Comparator.comparing(ArchiveType::getName));
        return all;
    }

    @Generated
    public ArchiveTypeRepository(ArchiveTypeLoader archiveTypeLoader, ArchiveCryptoService archiveCryptoService) {
        this.archiveTypeLoader = archiveTypeLoader;
        this.archiveCryptoService = archiveCryptoService;
    }
}

