/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.avro.repository;

import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveType;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeId;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeRepository;
import ch.admin.bit.jeap.processarchive.domain.archive.lifecycle.LifecyclePolicy;
import ch.admin.bit.jeap.processarchive.domain.archive.lifecycle.LifecyclePolicyService;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedata.ArchiveData;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class ArchiveTypeLifecyclePolicyService
implements LifecyclePolicyService {
    private final ArchiveTypeRepository archiveTypeRepository;

    public LifecyclePolicy getLifecyclePolicy(ArchiveData archiveData) {
        String archiveDataTypeName = archiveData.getSchema();
        String systemName = archiveData.getSystem();
        ArchiveTypeId archiveTypeId = ArchiveTypeId.builder().system(systemName).name(archiveDataTypeName).version(archiveData.getSchemaVersion()).build();
        ArchiveType archiveType = this.archiveTypeRepository.requireArchiveType(archiveTypeId);
        return this.createLifecyclePolicy(archiveType);
    }

    public List<LifecyclePolicy> getAllLifecyclePolicies() {
        return this.archiveTypeRepository.findAll().stream().map(this::createLifecyclePolicy).distinct().collect(Collectors.toList());
    }

    private LifecyclePolicy createLifecyclePolicy(ArchiveType archiveType) {
        return LifecyclePolicy.builder().systemName(archiveType.getSystem()).archiveTypeName(archiveType.getName()).currentVersionExpirationDays(archiveType.getExpirationDays().intValue()).previousVersionExpirationDays(archiveType.getExpirationDays().intValue()).retainDays(archiveType.getExpirationDays().intValue()).build();
    }

    @Generated
    public ArchiveTypeLifecyclePolicyService(ArchiveTypeRepository archiveTypeRepository) {
        this.archiveTypeRepository = archiveTypeRepository;
    }
}

