/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.avro.repository;

import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveType;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeEncryption;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeEncryptionKey;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeId;
import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeLoaderException;
import ch.admin.bit.jeap.processarchive.plugin.api.archivetype.ArchiveTypeProvider;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecordBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class ArchiveTypeLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArchiveTypeLoader.class);
    private final ArchiveTypeProvider archiveTypeProvider;

    ArchiveTypeLoader(ArchiveTypeProvider archiveTypeProvider) {
        this.archiveTypeProvider = archiveTypeProvider;
    }

    Map<ArchiveTypeId, ArchiveType> loadArchiveTypes() {
        List typeVersions = this.archiveTypeProvider.getArchiveTypeVersions();
        log.info("Loading archive types: {}", typeVersions.stream().map(Class::getName).toList());
        HashMap<ArchiveTypeId, ArchiveType> archiveTypes = new HashMap<ArchiveTypeId, ArchiveType>();
        typeVersions.forEach(v -> this.loadArchiveTypeVersion((Class<? extends SpecificRecordBase>)v, (Map<ArchiveTypeId, ArchiveType>)archiveTypes));
        return archiveTypes;
    }

    private void loadArchiveTypeVersion(Class<? extends SpecificRecordBase> archiveTypeClass, Map<ArchiveTypeId, ArchiveType> archiveTypes) {
        Map<String, Object> metadata = this.getArchiveTypeMetadata(archiveTypeClass);
        ArchiveType archiveType = this.createArchiveType(metadata);
        ArchiveTypeId archiveTypeId = ArchiveTypeId.builder().system(archiveType.getSystem()).name(archiveType.getName()).version(archiveType.getVersion()).build();
        archiveTypes.put(archiveTypeId, archiveType);
    }

    private ArchiveType createArchiveType(Map<String, Object> metadata) {
        return ArchiveType.builder().name((String)metadata.get("archiveTypeName")).version((Integer)metadata.get("archiveTypeVersion")).system((String)metadata.get("systemName")).referenceIdType((String)metadata.get("referenceIdType")).expirationDays((Integer)metadata.get("expirationDays")).schema((Schema)metadata.get("schema")).encryption(this.getArchiveTypeEncryptionFromDescriptor(metadata)).encryptionKey(this.getArchiveTypeEncryptionKeyFromDescriptor(metadata)).build();
    }

    private Map<String, Object> getArchiveTypeMetadata(Class<? extends SpecificRecordBase> archiveTypeClass) {
        Object archiveTypeMetadata = ReflectionUtils.getField((Field)ArchiveTypeLoader.getField(archiveTypeClass), archiveTypeClass);
        return (Map)archiveTypeMetadata;
    }

    private static Field getField(Class<? extends SpecificRecordBase> archiveTypeClass) {
        try {
            return archiveTypeClass.getField("ARCHIVE_TYPE_METADATA");
        }
        catch (NoSuchFieldException e) {
            throw ArchiveTypeLoaderException.missingMetadataField(archiveTypeClass, e);
        }
    }

    private ArchiveTypeEncryption getArchiveTypeEncryptionFromDescriptor(Map<String, Object> metadata) {
        if (metadata.containsKey("encryptionSecretEnginePath")) {
            return ArchiveTypeEncryption.builder().secretEnginePath((String)metadata.get("encryptionSecretEnginePath")).keyName((String)metadata.get("encryptionKeyName")).build();
        }
        return null;
    }

    private ArchiveTypeEncryptionKey getArchiveTypeEncryptionKeyFromDescriptor(Map<String, Object> metadata) {
        if (metadata.containsKey("encryptionKeyId")) {
            return ArchiveTypeEncryptionKey.builder().keyId((String)metadata.get("encryptionKeyId")).build();
        }
        return null;
    }
}

