/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.avro.repository;

import ch.admin.bit.jeap.processarchive.avro.repository.ArchiveTypeId;
import java.nio.file.Path;
import org.apache.avro.specific.SpecificRecordBase;

public class ArchiveTypeLoaderException
extends RuntimeException {
    private ArchiveTypeLoaderException(String message) {
        super(message);
    }

    private ArchiveTypeLoaderException(String message, Exception exception) {
        super(message, exception);
    }

    static ArchiveTypeLoaderException schemaFileNotFound(Path descriptorDir, String filename) {
        return new ArchiveTypeLoaderException(String.format("Schema file %s referenced in descriptor %s not found", filename, descriptorDir));
    }

    static ArchiveTypeLoaderException avroSchemaParsingFailed(Path schemaFile, Exception exception) {
        return new ArchiveTypeLoaderException("Failed to parse schema file " + String.valueOf(schemaFile), exception);
    }

    static ArchiveTypeLoaderException archiveTypeNotFound(ArchiveTypeId archiveTypeId) {
        return new ArchiveTypeLoaderException("Archive type unknown: " + String.valueOf(archiveTypeId));
    }

    public static ArchiveTypeLoaderException missingMetadataField(Class<? extends SpecificRecordBase> archiveTypeClass, NoSuchFieldException e) {
        return new ArchiveTypeLoaderException("Missing metadata field in archive type class " + archiveTypeClass.getName(), e);
    }
}

