/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.domain.archive.schema;

import ch.admin.bit.jeap.processarchive.domain.archive.schema.ArchiveDataSchemaValidator;
import ch.admin.bit.jeap.processarchive.domain.archive.schema.SchemaValidationException;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedata.ArchiveData;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedata.schema.ArchiveDataSchema;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.stereotype.Component;

@Component
public class ArchiveDataSchemaValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArchiveDataSchemaValidationService.class);
    private final List<ArchiveDataSchemaValidator> schemaValidatorBeans;
    private final Map<String, ArchiveDataSchemaValidator> schemaValidatorsByContentType = new ConcurrentHashMap<String, ArchiveDataSchemaValidator>();

    @PostConstruct
    public void initValidators() {
        this.schemaValidatorBeans.stream().sorted(AnnotationAwareOrderComparator.INSTANCE.reversed()).forEach(this::registerValidator);
        log.info("Registered schema validators: {}", this.schemaValidatorsByContentType);
    }

    private void registerValidator(ArchiveDataSchemaValidator schemaValidator) {
        for (String contentType : schemaValidator.getContentTypes()) {
            ArchiveDataSchemaValidator registeredValidator = this.schemaValidatorsByContentType.put(contentType.toLowerCase(), schemaValidator);
            if (registeredValidator == null) continue;
            log.warn("More than one schema validator registered for content type {}: {} and {}", new Object[]{contentType, registeredValidator, schemaValidator});
        }
    }

    public ArchiveDataSchema validateArchiveDataSchema(ArchiveData archiveData) {
        String contentType = archiveData.getContentType().toLowerCase();
        ArchiveDataSchemaValidator archiveDataSchemaValidator = this.schemaValidatorsByContentType.get(contentType);
        if (archiveDataSchemaValidator != null) {
            return archiveDataSchemaValidator.validatePayloadConformsToSchema(archiveData);
        }
        throw SchemaValidationException.noValidatorForContentType(archiveData, contentType);
    }

    @Generated
    public ArchiveDataSchemaValidationService(List<ArchiveDataSchemaValidator> schemaValidatorBeans) {
        this.schemaValidatorBeans = schemaValidatorBeans;
    }
}

