/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.domain.archive;

import ch.admin.bit.jeap.domainevent.DomainEvent;
import ch.admin.bit.jeap.messaging.model.Message;
import ch.admin.bit.jeap.processarchive.domain.archive.ArchiveDataObjectStore;
import ch.admin.bit.jeap.processarchive.domain.archive.ArchiveDataStorageInfo;
import ch.admin.bit.jeap.processarchive.domain.archive.ProcessArchiveException;
import ch.admin.bit.jeap.processarchive.domain.archive.schema.ArchiveDataSchemaValidationService;
import ch.admin.bit.jeap.processarchive.domain.configuration.DomainEventArchiveConfiguration;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedartifact.ArchivedArtifact;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedartifact.ArtifactArchivedListener;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedata.ArchiveData;
import ch.admin.bit.jeap.processarchive.plugin.api.archivedata.schema.ArchiveDataSchema;
import io.micrometer.core.annotation.Timed;
import java.util.List;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.util.NamedFeature;

@Component
public class DomainEventArchiveService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DomainEventArchiveService.class);
    private final List<ArtifactArchivedListener> artifactArchivedListener;
    private final ArchiveDataObjectStore archiveDataObjectStore;
    private final ArchiveDataSchemaValidationService validationService;
    private final FeatureManager featureManager;

    @Timed(value="jeap_pas_archive_domain_event", description="Archive DomainEvent from fetch to commit")
    public void archive(DomainEventArchiveConfiguration configuration, DomainEvent event) {
        String processId = this.readOriginProcessId(configuration, event);
        if (!configuration.acceptsMessage((Message)event)) {
            log.debug("Condition prevented archiving data for event {}", (Object)event.getIdentity().getId());
            return;
        }
        ArchiveData archiveData = this.readArchiveData(configuration, event);
        if (archiveData == null) {
            log.info("No data to archive for event {}", (Object)event.getIdentity().getId());
            return;
        }
        log.info("Extracted archive data from event {}: {} {} {}", new Object[]{StructuredArguments.keyValue((String)"eventType", (Object)event.getType().getName()), StructuredArguments.keyValue((String)"processId", (Object)processId), StructuredArguments.keyValue((String)"referenceId", (Object)archiveData.getReferenceId()), StructuredArguments.keyValue((String)"version", (Object)archiveData.getVersion())});
        ArchiveDataSchema schema = this.validationService.validateArchiveDataSchema(archiveData);
        ArchivedArtifact archivedArtifact = this.archiveArtifact(archiveData, schema, processId, this.createArchiveArtifactIdempotenceId(event));
        if (this.isFeatureFlagActive(configuration)) {
            this.artifactArchivedListener.forEach(listener -> listener.onArtifactArchived(archivedArtifact));
        }
    }

    private boolean isFeatureFlagActive(DomainEventArchiveConfiguration configuration) {
        if (configuration.getFeatureFlag() != null) {
            boolean active = this.featureManager.isActive((Feature)new NamedFeature(configuration.getFeatureFlag()));
            log.debug("FeatureFlag={} eventName={} state={}", new Object[]{configuration.getFeatureFlag(), configuration.getEventName(), active});
            return active;
        }
        return true;
    }

    private ArchivedArtifact archiveArtifact(ArchiveData archiveData, ArchiveDataSchema schema, String processId, String idempotenceId) {
        ArchiveDataStorageInfo archiveDataStorageInfo = this.archiveDataObjectStore.store(archiveData, schema);
        return ArchivedArtifact.builder().archiveData(archiveData).idempotenceId(idempotenceId).referenceIdType(schema.getReferenceIdType()).processId(processId).storageObjectBucket(archiveDataStorageInfo.getBucket()).storageObjectKey(archiveDataStorageInfo.getKey()).storageObjectId(archiveDataStorageInfo.getName()).storageObjectVersionId(archiveDataStorageInfo.getVersionId()).expirationDays(schema.getExpirationDays()).build();
    }

    private ArchiveData readArchiveData(DomainEventArchiveConfiguration configuration, DomainEvent event) {
        try {
            return configuration.getArchiveDataFactory().createArchiveData(event);
        }
        catch (Exception ex) {
            throw ProcessArchiveException.failedToReadData(event, ex);
        }
    }

    private String createArchiveArtifactIdempotenceId(DomainEvent event) {
        return event.getType().getName() + "_" + event.getIdentity().getIdempotenceId();
    }

    private String readOriginProcessId(DomainEventArchiveConfiguration configuration, DomainEvent event) {
        if (configuration.getCorrelationProvider() != null) {
            String processId = configuration.getCorrelationProvider().getOriginProcessId((Message)event);
            if (processId == null) {
                throw ProcessArchiveException.processIdFromCorrelationProviderMissing(event, configuration.getCorrelationProvider());
            }
            log.debug("Found processId '{}' from correlationProvider", (Object)processId);
            return processId;
        }
        return (String)event.getOptionalProcessId().orElseThrow(ProcessArchiveException.mandatoryProcessIdMissing(event));
    }

    @Generated
    public DomainEventArchiveService(List<ArtifactArchivedListener> artifactArchivedListener, ArchiveDataObjectStore archiveDataObjectStore, ArchiveDataSchemaValidationService validationService, FeatureManager featureManager) {
        this.artifactArchivedListener = artifactArchivedListener;
        this.archiveDataObjectStore = archiveDataObjectStore;
        this.validationService = validationService;
        this.featureManager = featureManager;
    }
}

