/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.reader;

import ch.admin.bit.jeap.processarchive.reader.ProcessArchiveReaderException;
import ch.admin.bit.jeap.processarchive.reader.objectstorage.S3StorageObjectRepository;
import ch.admin.bit.jeap.processarchive.reader.objectstorage.StorageObject;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.model.S3Exception;

public class ProcessArchiveReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessArchiveReader.class);
    public static final String SCHEMA_FILE_KEY = "schema-file-key";
    private final S3StorageObjectRepository s3StorageObjectRepository;

    public <T> T readArtifact(Class<T> archiveBindingType, String bucket, String key) {
        return this.readArtifact(archiveBindingType, bucket, key, null);
    }

    public <T> T readArtifact(Class<T> archiveBindingType, String bucket, String key, String version) {
        log.debug("Read artifact of type {} from bucket {} with key {}", new Object[]{archiveBindingType.getName(), bucket, key});
        Optional<String> versionOptional = Optional.ofNullable(version);
        StorageObject storageObject = this.s3StorageObjectRepository.getObject(bucket, this.removeLeadingSlash(key), versionOptional);
        SpecificDatumReader datumReader = new SpecificDatumReader();
        datumReader.setSchema(this.getWriterSchema(bucket, storageObject));
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(storageObject.data(), null);
        try {
            return (T)datumReader.read(null, (Decoder)decoder);
        }
        catch (AvroTypeException e) {
            throw ProcessArchiveReaderException.readException(archiveBindingType.getName(), bucket, key, e);
        }
        catch (IOException e) {
            throw ProcessArchiveReaderException.ioException(archiveBindingType.getName(), bucket, key, e);
        }
    }

    private Schema getWriterSchema(String bucket, StorageObject storageObject) {
        String schemaFileKey = storageObject.metadata().get(SCHEMA_FILE_KEY);
        try {
            byte[] schema = this.s3StorageObjectRepository.getObjectAsBytes(bucket, schemaFileKey);
            return ProcessArchiveReader.parseSchema(bucket, schema, schemaFileKey);
        }
        catch (S3Exception exception) {
            throw ProcessArchiveReaderException.writerSchemaNotReadableException(bucket, schemaFileKey, exception);
        }
    }

    private static Schema parseSchema(String bucket, byte[] schema, String schemaFileKey) {
        try {
            return new Schema.Parser().parse(new String(schema));
        }
        catch (Exception e) {
            throw ProcessArchiveReaderException.writerSchemaParseException(bucket, schemaFileKey, e);
        }
    }

    private String removeLeadingSlash(String pathSegments) {
        return pathSegments.startsWith("/") ? pathSegments.substring(1) : pathSegments;
    }

    @Generated
    public ProcessArchiveReader(S3StorageObjectRepository s3StorageObjectRepository) {
        this.s3StorageObjectRepository = s3StorageObjectRepository;
    }
}

