/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.reader.objectstorage;

import ch.admin.bit.jeap.processarchive.reader.objectstorage.S3ObjectStorageConnectionProperties;
import java.net.URI;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.signer.AwsS3V4Signer;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.http.urlconnection.ProxyConfiguration;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

@Configuration
@EnableConfigurationProperties(value={S3ObjectStorageConnectionProperties.class})
public class S3ObjectStorageConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3ObjectStorageConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(value={S3Client.class})
    @ConditionalOnProperty(value={"jeap.process-archive.reader.connection.access-url"})
    S3Client s3Client(S3ObjectStorageConnectionProperties connectionProperties) {
        log.info("Initializing s3Client with connection properties {}.", (Object)connectionProperties.toString());
        ClientOverrideConfiguration.Builder overrideConfig = ClientOverrideConfiguration.builder();
        overrideConfig.advancedOptions(Map.of(SdkAdvancedClientOption.SIGNER, AwsS3V4Signer.create()));
        S3ClientBuilder s3ClientBuilder = (S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(connectionProperties.getRegion())).forcePathStyle(Boolean.valueOf(true))).credentialsProvider(this.awsCredentialsProvider(connectionProperties))).httpClient(UrlConnectionHttpClient.builder().proxyConfiguration((ProxyConfiguration)ProxyConfiguration.builder().useSystemPropertyValues(Boolean.valueOf(false)).useEnvironmentVariablesValues(Boolean.valueOf(false)).build()).build())).overrideConfiguration((ClientOverrideConfiguration)overrideConfig.build());
        if (StringUtils.hasText((String)connectionProperties.getAccessUrl())) {
            log.info("Overriding endpoint in S3Client...");
            s3ClientBuilder = (S3ClientBuilder)s3ClientBuilder.endpointOverride(this.retrieveEndpointURI(connectionProperties.getAccessUrl()));
        }
        S3Client s3Client = (S3Client)s3ClientBuilder.build();
        log.info("The initialization of s3Client was successful");
        return s3Client;
    }

    private AwsCredentialsProvider awsCredentialsProvider(S3ObjectStorageConnectionProperties props) {
        if (props.getAccessKey() != null && props.getSecretKey() != null) {
            log.debug("Creating AwsCredentialsProvider using configured accessKey and secretKey...");
            return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)props.getAccessKey(), (String)props.getSecretKey()));
        }
        return DefaultCredentialsProvider.create();
    }

    private URI retrieveEndpointURI(String accessUrl) {
        if (accessUrl.startsWith("http://") || accessUrl.startsWith("https://")) {
            return URI.create(accessUrl);
        }
        return URI.create("https://" + accessUrl);
    }
}

