/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processarchive.reader.objectstorage;

import ch.admin.bit.jeap.processarchive.reader.objectstorage.StorageObject;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;

public class S3StorageObjectRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(S3StorageObjectRepository.class);
    private final S3Client s3Client;

    public byte[] getObjectAsBytes(String bucketName, String objectKey) {
        GetObjectRequest request = this.createGetObjectRequest(bucketName, objectKey, Optional.empty());
        return this.s3Client.getObjectAsBytes(request).asByteArray();
    }

    public StorageObject getObject(String bucketName, String objectKey, Optional<String> objectVersionId) {
        GetObjectRequest request = this.createGetObjectRequest(bucketName, objectKey, objectVersionId);
        byte[] data = this.s3Client.getObjectAsBytes(request).asByteArray();
        Map<String, String> metadata = this.getMetadata(bucketName, objectKey, objectVersionId);
        return new StorageObject(objectKey, data, metadata);
    }

    private GetObjectRequest createGetObjectRequest(String bucketName, String objectKey, Optional<String> objectVersionId) {
        if (objectVersionId.isPresent()) {
            log.debug("Getting object with key '{}' and version id '{}' from bucket '{}'.", new Object[]{objectKey, objectVersionId.get(), bucketName});
            return (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(objectKey).versionId(objectVersionId.get()).build();
        }
        log.debug("Getting object with key '{}' from bucket '{}'.", (Object)objectKey, (Object)bucketName);
        return (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(objectKey).build();
    }

    private Map<String, String> getMetadata(String bucketName, String objectKey, Optional<String> objectVersionId) {
        HeadObjectRequest request = this.createGetObjectMetadataRequest(bucketName, objectKey, objectVersionId);
        return this.s3Client.headObject(request).metadata();
    }

    private HeadObjectRequest createGetObjectMetadataRequest(String bucketName, String objectKey, Optional<String> objectVersionId) {
        if (objectVersionId.isPresent()) {
            log.debug("Getting metadata for object with key '{}' and version id '{}' from bucket '{}'.", new Object[]{objectKey, objectVersionId.get(), bucketName});
            return (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucketName).key(objectKey).versionId(objectVersionId.get()).build();
        }
        log.debug("Getting metadata for object with key '{}' from bucket '{}'.", (Object)objectKey, (Object)bucketName);
        return (HeadObjectRequest)HeadObjectRequest.builder().bucket(bucketName).key(objectKey).build();
    }

    @Generated
    public S3StorageObjectRepository(S3Client s3Client) {
        this.s3Client = s3Client;
    }
}

