/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.adapter.kafka;

import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessTemplateRepository;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.KafkaAdmin;

@Configuration
@ConfigurationProperties(prefix="jeap.processcontext.kafka.topic")
public class TopicConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopicConfiguration.class);
    public static final String PROCESS_INSTANCE_CREATED_EVENT_TOPIC_NAME = "${jeap.processcontext.kafka.topic.process-instance-created}";
    public static final String PROCESS_INSTANCE_COMPLETED_EVENT_TOPIC_NAME = "${jeap.processcontext.kafka.topic.process-instance-completed}";
    public static final String PROCESS_MILESTONE_REACHED_EVENT_TOPIC_NAME = "${jeap.processcontext.kafka.topic.process-milestone-reached}";
    public static final String PROCESS_OUTDATED_TOPIC_NAME = "${jeap.processcontext.kafka.topic.process-outdated-internal}";
    public static final String PROCESS_STATE_CHANGED_TOPIC_NAME = "${jeap.processcontext.kafka.topic.process-changed-internal}";
    public static final String CREATE_PROCESS_INSTANCE_TOPIC_NAME = "${jeap.processcontext.kafka.topic.create-process-instance}";
    private static final String EVENT_PROCESSING_FAILED_TOPIC_NAME = "${jeap.messaging.kafka.error-topic-name}";
    public static final String PROCESS_SNAPSHOT_CREATED_EVENT_TOPIC_NAME = "${jeap.processcontext.kafka.topic.process-snapshot-created}";
    private String processOutdatedInternal;
    private String processChangedInternal;
    private String processInstanceCreated;
    private String processInstanceCompleted;
    private String processMilestoneReached;
    private String createProcessInstance;
    private String processSnapshotCreated;

    @Generated
    public TopicConfiguration() {
    }

    @Generated
    public String getProcessOutdatedInternal() {
        return this.processOutdatedInternal;
    }

    @Generated
    public String getProcessChangedInternal() {
        return this.processChangedInternal;
    }

    @Generated
    public String getProcessInstanceCreated() {
        return this.processInstanceCreated;
    }

    @Generated
    public String getProcessInstanceCompleted() {
        return this.processInstanceCompleted;
    }

    @Generated
    public String getProcessMilestoneReached() {
        return this.processMilestoneReached;
    }

    @Generated
    public String getCreateProcessInstance() {
        return this.createProcessInstance;
    }

    @Generated
    public String getProcessSnapshotCreated() {
        return this.processSnapshotCreated;
    }

    @Generated
    public void setProcessOutdatedInternal(String processOutdatedInternal) {
        this.processOutdatedInternal = processOutdatedInternal;
    }

    @Generated
    public void setProcessChangedInternal(String processChangedInternal) {
        this.processChangedInternal = processChangedInternal;
    }

    @Generated
    public void setProcessInstanceCreated(String processInstanceCreated) {
        this.processInstanceCreated = processInstanceCreated;
    }

    @Generated
    public void setProcessInstanceCompleted(String processInstanceCompleted) {
        this.processInstanceCompleted = processInstanceCompleted;
    }

    @Generated
    public void setProcessMilestoneReached(String processMilestoneReached) {
        this.processMilestoneReached = processMilestoneReached;
    }

    @Generated
    public void setCreateProcessInstance(String createProcessInstance) {
        this.createProcessInstance = createProcessInstance;
    }

    @Generated
    public void setProcessSnapshotCreated(String processSnapshotCreated) {
        this.processSnapshotCreated = processSnapshotCreated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicConfiguration)) {
            return false;
        }
        TopicConfiguration other = (TopicConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$processOutdatedInternal = this.getProcessOutdatedInternal();
        String other$processOutdatedInternal = other.getProcessOutdatedInternal();
        if (this$processOutdatedInternal == null ? other$processOutdatedInternal != null : !this$processOutdatedInternal.equals(other$processOutdatedInternal)) {
            return false;
        }
        String this$processChangedInternal = this.getProcessChangedInternal();
        String other$processChangedInternal = other.getProcessChangedInternal();
        if (this$processChangedInternal == null ? other$processChangedInternal != null : !this$processChangedInternal.equals(other$processChangedInternal)) {
            return false;
        }
        String this$processInstanceCreated = this.getProcessInstanceCreated();
        String other$processInstanceCreated = other.getProcessInstanceCreated();
        if (this$processInstanceCreated == null ? other$processInstanceCreated != null : !this$processInstanceCreated.equals(other$processInstanceCreated)) {
            return false;
        }
        String this$processInstanceCompleted = this.getProcessInstanceCompleted();
        String other$processInstanceCompleted = other.getProcessInstanceCompleted();
        if (this$processInstanceCompleted == null ? other$processInstanceCompleted != null : !this$processInstanceCompleted.equals(other$processInstanceCompleted)) {
            return false;
        }
        String this$processMilestoneReached = this.getProcessMilestoneReached();
        String other$processMilestoneReached = other.getProcessMilestoneReached();
        if (this$processMilestoneReached == null ? other$processMilestoneReached != null : !this$processMilestoneReached.equals(other$processMilestoneReached)) {
            return false;
        }
        String this$createProcessInstance = this.getCreateProcessInstance();
        String other$createProcessInstance = other.getCreateProcessInstance();
        if (this$createProcessInstance == null ? other$createProcessInstance != null : !this$createProcessInstance.equals(other$createProcessInstance)) {
            return false;
        }
        String this$processSnapshotCreated = this.getProcessSnapshotCreated();
        String other$processSnapshotCreated = other.getProcessSnapshotCreated();
        return !(this$processSnapshotCreated == null ? other$processSnapshotCreated != null : !this$processSnapshotCreated.equals(other$processSnapshotCreated));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TopicConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $processOutdatedInternal = this.getProcessOutdatedInternal();
        result = result * 59 + ($processOutdatedInternal == null ? 43 : $processOutdatedInternal.hashCode());
        String $processChangedInternal = this.getProcessChangedInternal();
        result = result * 59 + ($processChangedInternal == null ? 43 : $processChangedInternal.hashCode());
        String $processInstanceCreated = this.getProcessInstanceCreated();
        result = result * 59 + ($processInstanceCreated == null ? 43 : $processInstanceCreated.hashCode());
        String $processInstanceCompleted = this.getProcessInstanceCompleted();
        result = result * 59 + ($processInstanceCompleted == null ? 43 : $processInstanceCompleted.hashCode());
        String $processMilestoneReached = this.getProcessMilestoneReached();
        result = result * 59 + ($processMilestoneReached == null ? 43 : $processMilestoneReached.hashCode());
        String $createProcessInstance = this.getCreateProcessInstance();
        result = result * 59 + ($createProcessInstance == null ? 43 : $createProcessInstance.hashCode());
        String $processSnapshotCreated = this.getProcessSnapshotCreated();
        result = result * 59 + ($processSnapshotCreated == null ? 43 : $processSnapshotCreated.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TopicConfiguration(processOutdatedInternal=" + this.getProcessOutdatedInternal() + ", processChangedInternal=" + this.getProcessChangedInternal() + ", processInstanceCreated=" + this.getProcessInstanceCreated() + ", processInstanceCompleted=" + this.getProcessInstanceCompleted() + ", processMilestoneReached=" + this.getProcessMilestoneReached() + ", createProcessInstance=" + this.getCreateProcessInstance() + ", processSnapshotCreated=" + this.getProcessSnapshotCreated() + ")";
    }

    @Configuration
    @Profile(value={"local"})
    private static class TopicConfigurationLocal {
        private final TopicConfiguration topicConfiguration;
        @Value(value="${jeap.messaging.kafka.error-topic-name}")
        private String eventProcessingFailedTopicName;

        @Bean
        public NewTopic processChangedInternalTopic() {
            return new NewTopic(this.topicConfiguration.getProcessChangedInternal(), 1, 1);
        }

        @Bean
        public NewTopic processOutdatedInternalTopic() {
            return new NewTopic(this.topicConfiguration.getProcessOutdatedInternal(), 1, 1);
        }

        @Bean
        public NewTopic processInstanceCreatedTopic() {
            return new NewTopic(this.topicConfiguration.getProcessInstanceCreated(), 1, 1);
        }

        @Bean
        public NewTopic processInstanceCompletedTopic() {
            return new NewTopic(this.topicConfiguration.getProcessInstanceCompleted(), 1, 1);
        }

        @Bean
        public NewTopic processMilestoneReachedTopic() {
            return new NewTopic(this.topicConfiguration.getProcessMilestoneReached(), 1, 1);
        }

        @Bean
        public NewTopic eventProcessingFailedTopic() {
            return new NewTopic(this.eventProcessingFailedTopicName, 1, 1);
        }

        @Bean
        public NewTopic createProcessInstance() {
            return new NewTopic(this.topicConfiguration.getCreateProcessInstance(), 1, 1);
        }

        @Bean
        public NewTopic processSnapshotCreatedTopic() {
            return new NewTopic(this.topicConfiguration.getProcessSnapshotCreated(), 1, 1);
        }

        @Generated
        public TopicConfigurationLocal(TopicConfiguration topicConfiguration) {
            this.topicConfiguration = topicConfiguration;
        }
    }

    @Configuration
    @Profile(value={"!local"})
    private static class TopicConfigurationCloud {
        private final KafkaAdmin kafkaAdmin;
        private final TopicConfiguration topicConfiguration;
        private final ProcessTemplateRepository processTemplateRepository;
        @Value(value="${jeap.messaging.kafka.error-topic-name}")
        private String eventProcessingFailedTopicName;

        @PostConstruct
        public void checkIfTopicsExist() throws ExecutionException, InterruptedException {
            try (AdminClient adminClient = AdminClient.create((Map)this.kafkaAdmin.getConfigurationProperties());){
                ArrayList<String> topicNames = new ArrayList<String>(List.of(this.topicConfiguration.getProcessChangedInternal(), this.topicConfiguration.getProcessOutdatedInternal(), this.topicConfiguration.getProcessInstanceCreated(), this.topicConfiguration.getProcessInstanceCompleted(), this.topicConfiguration.getProcessMilestoneReached(), this.topicConfiguration.getCreateProcessInstance(), this.eventProcessingFailedTopicName));
                if (this.processTemplateRepository.hasProcessSnapshotsConfigured()) {
                    topicNames.add(this.topicConfiguration.getProcessSnapshotCreated());
                }
                adminClient.describeTopics(topicNames).allTopicNames().get();
            }
        }

        @Generated
        public TopicConfigurationCloud(KafkaAdmin kafkaAdmin, TopicConfiguration topicConfiguration, ProcessTemplateRepository processTemplateRepository) {
            this.kafkaAdmin = kafkaAdmin;
            this.topicConfiguration = topicConfiguration;
            this.processTemplateRepository = processTemplateRepository;
        }
    }
}

