/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.adapter.kafka.internalevent.consumer;

import ch.admin.bit.jeap.processcontext.adapter.kafka.internalevent.consumer.InternalMessageUtil;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstanceService;
import ch.admin.bit.jeap.processcontext.internal.event.outdated.ProcessContextOutdatedEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaHandler;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

@Component
@KafkaListener(groupId="${spring.application.name}-event-received", topics={"${jeap.processcontext.kafka.topic.process-outdated-internal}"})
public class ProcessContextOutdatedEventConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessContextOutdatedEventConsumer.class);
    private final ProcessInstanceService processInstanceService;

    @KafkaHandler
    public void consumeProcessContextUpdatedEvent(ProcessContextOutdatedEvent event, Acknowledgment ack) {
        String originProcessId = event.getProcessId();
        InternalMessageUtil.handleAndAcknowledge(originProcessId, ack, this::updateProcessState);
    }

    private void updateProcessState(String originProcessId) {
        log.debug("Received process update message for process ID {}", (Object)originProcessId);
        this.processInstanceService.updateProcessState(originProcessId);
    }

    @Generated
    public ProcessContextOutdatedEventConsumer(ProcessInstanceService processInstanceService) {
        this.processInstanceService = processInstanceService;
    }
}

