/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.adapter.kafka.internalevent.consumer;

import ch.admin.bit.jeap.processcontext.adapter.kafka.internalevent.consumer.InternalMessageUtil;
import ch.admin.bit.jeap.processcontext.domain.processevent.ProcessEventService;
import ch.admin.bit.jeap.processcontext.internal.event.statechanged.ProcessContextStateChangedEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaHandler;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

@Component
@KafkaListener(groupId="${spring.application.name}-state-changed", topics={"${jeap.processcontext.kafka.topic.process-changed-internal}"})
public class ProcessContextStateChangedEventConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessContextStateChangedEventConsumer.class);
    private final ProcessEventService processEventService;

    @KafkaHandler
    public void consumeProcessStateChangedMessage(ProcessContextStateChangedEvent event, Acknowledgment ack) {
        String originProcessId = event.getProcessId();
        InternalMessageUtil.handleAndAcknowledge(originProcessId, ack, this::reactToStateChange);
    }

    private void reactToStateChange(String originProcessId) {
        log.debug("Received process state changed message for process ID {}", (Object)originProcessId);
        this.processEventService.reactToProcessStateChange(originProcessId);
    }

    @Generated
    public ProcessContextStateChangedEventConsumer(ProcessEventService processEventService) {
        this.processEventService = processEventService;
    }
}

