/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.adapter.kafka.command.consumer;

import ch.admin.bit.jeap.processcontext.adapter.kafka.message.consumer.KafkaEventListenerException;
import ch.admin.bit.jeap.processcontext.command.process.instance.create.CreateProcessInstanceCommand;
import ch.admin.bit.jeap.processcontext.command.process.instance.create.CreateProcessInstanceCommandPayload;
import ch.admin.bit.jeap.processcontext.domain.port.MetricsListener;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessData;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstanceService;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

@Component
public class CreateProcessInstanceCommandConsumer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateProcessInstanceCommandConsumer.class);
    private final ProcessInstanceService processInstanceService;
    private final MetricsListener metricsListener;

    @KafkaListener(topics={"${jeap.processcontext.kafka.topic.create-process-instance}"}, groupId="${spring.application.name}-create-process-instance")
    public void consume(CreateProcessInstanceCommand command, Acknowledgment ack) {
        try {
            CreateProcessInstanceCommandPayload payload = command.getPayload();
            this.metricsListener.commandReceived(command.getType());
            this.processInstanceService.createProcessInstance(command.getProcessId(), payload.getProcessTemplateName(), this.toProcessData(payload.getProcessData()));
        }
        catch (Exception ex) {
            throw KafkaEventListenerException.from(ex);
        }
        ack.acknowledge();
    }

    private Set<ProcessData> toProcessData(List<ch.admin.bit.jeap.processcontext.command.process.instance.create.ProcessData> processData) {
        if (processData == null) {
            return Collections.emptySet();
        }
        return processData.stream().map(pd -> new ProcessData(pd.getKey(), pd.getValue(), pd.getRole())).collect(Collectors.toSet());
    }

    @Generated
    public CreateProcessInstanceCommandConsumer(ProcessInstanceService processInstanceService, MetricsListener metricsListener) {
        this.processInstanceService = processInstanceService;
        this.metricsListener = metricsListener;
    }
}

