/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.adapter.kafka.processevent.producer;

import ch.admin.bit.jeap.domainevent.avro.AvroDomainEvent;
import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.messaging.kafka.properties.KafkaProperties;
import ch.admin.bit.jeap.processcontext.adapter.kafka.TopicConfiguration;
import ch.admin.bit.jeap.processcontext.domain.port.ProcessInstanceEventProducer;
import ch.admin.bit.jeap.processcontext.event.ProcessInstanceCompletedEventBuilder;
import ch.admin.bit.jeap.processcontext.event.ProcessInstanceCreatedEventBuilder;
import ch.admin.bit.jeap.processcontext.event.ProcessMilestoneReachedEventBuilder;
import ch.admin.bit.jeap.processcontext.event.ProcessSnapshotCreatedEventBuilder;
import ch.admin.bit.jeap.processcontext.event.process.instance.completed.ProcessInstanceCompletedEvent;
import ch.admin.bit.jeap.processcontext.event.process.instance.created.ProcessInstanceCreatedEvent;
import ch.admin.bit.jeap.processcontext.event.process.milestone.reached.ProcessMilestoneReachedEvent;
import ch.admin.bit.jeap.processcontext.event.process.snapshot.created.ProcessSnapshotCreatedEvent;
import io.micrometer.core.annotation.Timed;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class DomainEventProcessInstanceEventProducer
implements ProcessInstanceEventProducer {
    private static final String CREATED_EVENT_IDEMPOTENCE_SUFFIX = "-created";
    private static final String COMPLETED_EVENT_IDEMPOTENCE_SUFFIX = "-completed";
    private static final String MILESTONE_REACHED_EVENT_IDEMPOTENCE_INFIX = "-milestone-reached-";
    private static final String SNAPSHOT_CREATED_EVENT_IDEMPOTENCE_INFIX = "-snapshot-created-";
    private final TopicConfiguration topicConfiguration;
    private final KafkaProperties kafkaProperties;
    private final KafkaTemplate<AvroMessageKey, AvroMessage> kafkaTemplate;

    @Timed(value="jeap_pcs_produce_process_instance_created_event", percentiles={0.5, 0.8, 0.95, 0.99})
    public void produceProcessInstanceCreatedEventSynchronously(String originProcessId, String processName) {
        ProcessInstanceCreatedEvent createdEvent = ((ProcessInstanceCreatedEventBuilder)ProcessInstanceCreatedEventBuilder.create().idempotenceId(originProcessId + CREATED_EVENT_IDEMPOTENCE_SUFFIX)).processId(originProcessId).processName(processName).systemName(this.kafkaProperties.getSystemName()).serviceName(this.kafkaProperties.getServiceName()).build();
        this.sendEventSynchronously((AvroDomainEvent)createdEvent, this.topicConfiguration.getProcessInstanceCreated());
    }

    @Timed(value="jeap_pcs_produce_process_instance_completed_event", percentiles={0.5, 0.8, 0.95, 0.99})
    public void produceProcessInstanceCompletedEventSynchronously(String originProcessId) {
        ProcessInstanceCompletedEvent completedEvent = ((ProcessInstanceCompletedEventBuilder)ProcessInstanceCompletedEventBuilder.create().idempotenceId(originProcessId + COMPLETED_EVENT_IDEMPOTENCE_SUFFIX)).processId(originProcessId).systemName(this.kafkaProperties.getSystemName()).serviceName(this.kafkaProperties.getServiceName()).build();
        this.sendEventSynchronously((AvroDomainEvent)completedEvent, this.topicConfiguration.getProcessInstanceCompleted());
    }

    @Timed(value="jeap_pcs_produce_process_milestone_reached_event", percentiles={0.5, 0.8, 0.95, 0.99})
    public void produceProcessMilestoneReachedEventSynchronously(String originProcessId, String milestoneName) {
        ProcessMilestoneReachedEvent milestoneReachedEvent = ((ProcessMilestoneReachedEventBuilder)ProcessMilestoneReachedEventBuilder.create().idempotenceId(originProcessId + MILESTONE_REACHED_EVENT_IDEMPOTENCE_INFIX + milestoneName)).processId(originProcessId).systemName(this.kafkaProperties.getSystemName()).serviceName(this.kafkaProperties.getServiceName()).milestoneName(milestoneName).build();
        this.sendEventSynchronously((AvroDomainEvent)milestoneReachedEvent, this.topicConfiguration.getProcessMilestoneReached());
    }

    @Timed(value="jeap_pcs_produce_process_snapshot_created_event", percentiles={0.5, 0.8, 0.95, 0.99})
    public void produceProcessSnapshotCreatedEventSynchronously(String originProcessId, int snapshotVersion) {
        ProcessSnapshotCreatedEvent snapshotCreatedEvent = ((ProcessSnapshotCreatedEventBuilder)ProcessSnapshotCreatedEventBuilder.create().idempotenceId(originProcessId + SNAPSHOT_CREATED_EVENT_IDEMPOTENCE_INFIX + snapshotVersion)).processId(originProcessId).systemName(this.kafkaProperties.getSystemName()).serviceName(this.kafkaProperties.getServiceName()).snapshotVersion(snapshotVersion).build();
        this.sendEventSynchronously((AvroDomainEvent)snapshotCreatedEvent, this.topicConfiguration.getProcessSnapshotCreated());
    }

    private void sendEventSynchronously(AvroDomainEvent event, String topic) {
        try {
            this.kafkaTemplate.send(topic, (Object)event).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Sending of " + DomainEventProcessInstanceEventProducer.getEventName(event) + " has been interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Sending of " + DomainEventProcessInstanceEventProducer.getEventName(event) + " failed with an exception.", e);
        }
    }

    private static String getEventName(AvroDomainEvent event) {
        return event.getType().getName();
    }

    @Generated
    public DomainEventProcessInstanceEventProducer(TopicConfiguration topicConfiguration, KafkaProperties kafkaProperties, KafkaTemplate<AvroMessageKey, AvroMessage> kafkaTemplate) {
        this.topicConfiguration = topicConfiguration;
        this.kafkaProperties = kafkaProperties;
        this.kafkaTemplate = kafkaTemplate;
    }
}

