/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.adapter.kafka.internalevent.producer;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.processcontext.adapter.kafka.TopicConfiguration;
import ch.admin.bit.jeap.processcontext.adapter.kafka.internalevent.producer.InternalMessageFactory;
import ch.admin.bit.jeap.processcontext.domain.port.InternalMessageProducer;
import ch.admin.bit.jeap.processcontext.domain.port.MetricsListener;
import ch.admin.bit.jeap.processcontext.internal.event.key.ProcessContextProcessIdKey;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import lombok.Generated;
import org.apache.avro.specific.SpecificRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
class InternalKafkaMessageProducer
implements InternalMessageProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalKafkaMessageProducer.class);
    private final KafkaTemplate<SpecificRecord, AvroMessage> internalKafkaTemplate;
    private final TopicConfiguration topicConfiguration;
    private final InternalMessageFactory internalMessageFactory;
    private final MetricsListener metricsListener;

    public InternalKafkaMessageProducer(KafkaTemplate<SpecificRecord, AvroMessage> internalKafkaTemplate, TopicConfiguration topicConfiguration, InternalMessageFactory internalMessageFactory, MetricsListener metricsListener) {
        this.internalKafkaTemplate = internalKafkaTemplate;
        this.topicConfiguration = topicConfiguration;
        this.internalMessageFactory = internalMessageFactory;
        this.metricsListener = metricsListener;
    }

    public void produceProcessContextOutdatedEventSynchronously(String originProcessId) {
        log.debug("Producing process outdated message for process ID {}", (Object)originProcessId);
        String topicName = this.topicConfiguration.getProcessOutdatedInternal();
        this.sendSynchronously(topicName, originProcessId, this.internalMessageFactory::processContextOutdatedEvent);
    }

    public void produceProcessContextStateChangedEventSynchronously(String originProcessId) {
        log.debug("Producing process state changed message for process ID {}", (Object)originProcessId);
        String topicName = this.topicConfiguration.getProcessChangedInternal();
        this.metricsListener.timed("jeap_pcs_produce_process_context_state_changed_event", Collections.emptyMap(), () -> this.sendSynchronously(topicName, originProcessId, this.internalMessageFactory::processContextStateChangedEvent));
    }

    private void sendSynchronously(String topicName, String originProcessId, Function<String, AvroMessage> messageFactory) {
        try {
            ProcessContextProcessIdKey key = this.internalMessageFactory.key(originProcessId);
            AvroMessage event = messageFactory.apply(originProcessId);
            this.internalKafkaTemplate.send(topicName, (Object)key, (Object)event).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Cannot send event", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Cannot send event", e);
        }
    }
}

