/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.adapter.kafka.message.consumer;

import ch.admin.bit.jeap.messaging.avro.AvroMessage;
import ch.admin.bit.jeap.messaging.avro.AvroMessageKey;
import ch.admin.bit.jeap.messaging.model.Message;
import ch.admin.bit.jeap.processcontext.adapter.kafka.message.consumer.KafkaEventListenerException;
import ch.admin.bit.jeap.processcontext.domain.message.MessageReceiver;
import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.support.Acknowledgment;

class KafkaMessageListener
implements AcknowledgingMessageListener<AvroMessageKey, AvroMessage> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaMessageListener.class);
    private final String eventName;
    private final MessageReceiver messageReceiver;

    public void onMessage(ConsumerRecord<AvroMessageKey, AvroMessage> record, Acknowledgment acknowledgment) {
        try {
            this.handleMessage(record);
        }
        catch (Exception ex) {
            throw KafkaEventListenerException.from(ex);
        }
        acknowledgment.acknowledge();
    }

    private void handleMessage(ConsumerRecord<AvroMessageKey, AvroMessage> record) {
        String receivedEventName = ((AvroMessage)record.value()).getType().getName();
        if (this.eventName.equals(receivedEventName)) {
            this.messageReceiver.messageReceived((Message)record.value());
        } else {
            this.logIgnoredMessage(record);
        }
    }

    private void logIgnoredMessage(ConsumerRecord<AvroMessageKey, AvroMessage> record) {
        log.debug("Ignoring event {} on topic {} as there is no matching message reference in the template / correlation provider", (Object)((AvroMessage)record.value()).getType().getName(), (Object)record.topic());
    }

    @Generated
    public KafkaMessageListener(String eventName, MessageReceiver messageReceiver) {
        this.eventName = eventName;
        this.messageReceiver = messageReceiver;
    }
}

