/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.adapter.kafka.internalevent.producer;

import ch.admin.bit.jeap.domainevent.avro.AvroDomainEventBuilder;
import ch.admin.bit.jeap.processcontext.internal.event.key.ProcessContextProcessIdKey;
import ch.admin.bit.jeap.processcontext.internal.event.outdated.ProcessContextOutdatedEvent;
import ch.admin.bit.jeap.processcontext.internal.event.outdated.ProcessContextOutdatedReferences;
import ch.admin.bit.jeap.processcontext.internal.event.statechanged.ProcessContextStateChangedEvent;
import ch.admin.bit.jeap.processcontext.internal.event.statechanged.ProcessContextStateChangedReferences;
import com.fasterxml.uuid.Generators;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
class InternalMessageFactory {
    @Value(value="${jeap.messaging.kafka.system-name}")
    private String systemName;
    @Value(value="${jeap.messaging.kafka.service-name}")
    private String serviceName;

    InternalMessageFactory() {
    }

    ProcessContextStateChangedEvent processContextStateChangedEvent(String originProcessId) {
        return (ProcessContextStateChangedEvent)new ProcessContextStateChangedEventBuilder(originProcessId).build();
    }

    ProcessContextOutdatedEvent processContextOutdatedEvent(String originProcessId) {
        return (ProcessContextOutdatedEvent)new ProcessContextUpdatedEventBuilder(originProcessId).build();
    }

    ProcessContextProcessIdKey key(String originProcessId) {
        return ProcessContextProcessIdKey.newBuilder().setProcessId(originProcessId).build();
    }

    private class ProcessContextStateChangedEventBuilder
    extends AvroDomainEventBuilder<ProcessContextStateChangedEventBuilder, ProcessContextStateChangedEvent> {
        protected ProcessContextStateChangedEventBuilder(String originProcessId) {
            super(ProcessContextStateChangedEvent::new);
            this.setProcessId(originProcessId);
            this.setReferences(ProcessContextStateChangedReferences.newBuilder().build());
            this.idempotenceId = Generators.timeBasedEpochGenerator().generate().toString();
        }

        protected String getSpecifiedMessageTypeVersion() {
            return "1.0.0";
        }

        protected String getServiceName() {
            return InternalMessageFactory.this.serviceName;
        }

        protected String getSystemName() {
            return InternalMessageFactory.this.systemName;
        }

        protected ProcessContextStateChangedEventBuilder self() {
            return this;
        }
    }

    private class ProcessContextUpdatedEventBuilder
    extends AvroDomainEventBuilder<ProcessContextUpdatedEventBuilder, ProcessContextOutdatedEvent> {
        protected ProcessContextUpdatedEventBuilder(String originProcessId) {
            super(ProcessContextOutdatedEvent::new);
            this.setProcessId(originProcessId);
            this.setReferences(ProcessContextOutdatedReferences.newBuilder().build());
            this.idempotenceId = Generators.timeBasedEpochGenerator().generate().toString();
        }

        protected String getSpecifiedMessageTypeVersion() {
            return "1.0.0";
        }

        protected String getServiceName() {
            return InternalMessageFactory.this.serviceName;
        }

        protected String getSystemName() {
            return InternalMessageFactory.this.systemName;
        }

        protected ProcessContextUpdatedEventBuilder self() {
            return this;
        }
    }
}

