/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processinstance;

import ch.admin.bit.jeap.processcontext.domain.message.Message;
import ch.admin.bit.jeap.processcontext.domain.message.MessageData;
import ch.admin.bit.jeap.processcontext.domain.message.MessageRepository;
import ch.admin.bit.jeap.processcontext.domain.message.OriginTaskId;
import ch.admin.bit.jeap.processcontext.domain.processinstance.Milestone;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessData;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstance;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessState;
import ch.admin.bit.jeap.processcontext.domain.processinstance.TaskInstance;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessDataTemplate;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessTemplate;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.RelationNodeSelector;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.RelationPattern;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.TaskCardinality;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.TaskData;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.TaskLifecycle;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.TaskType;
import ch.admin.bit.jeap.processcontext.plugin.api.condition.MilestoneCondition;
import com.fasterxml.uuid.Generators;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;

public final class ProcessInstanceStubs {
    public static final String task = "task";
    public static final String milestone = "milestone";
    public static final String neverReachedMilestone = "neverReachedMilestone";
    public static final String event = "event";
    private static final MilestoneCondition alwaysTrueMilestoneCondition = processContext -> true;
    private static final MilestoneCondition neverTrueMilestoneCondition = processContext -> false;

    public static ProcessInstance createProcessWithSingleTaskInstance() {
        return ProcessInstanceStubs.createProcessWithSingleTaskInstance("template", Collections.emptySet());
    }

    public static ProcessInstance createProcessWithSingleTaskInstance(String processTemplateName, Set<ProcessData> processData) {
        TaskType taskType = TaskType.builder().name(task).lifecycle(TaskLifecycle.STATIC).cardinality(TaskCardinality.SINGLE_INSTANCE).build();
        ProcessTemplate processTemplate = ProcessTemplate.builder().name(processTemplateName).templateHash("hash").taskTypes(Collections.singletonList(taskType)).milestones(Collections.emptyMap()).build();
        return ProcessInstance.startProcess((String)Generators.timeBasedEpochGenerator().generate().toString(), (ProcessTemplate)processTemplate, processData);
    }

    public static ProcessInstance createProcessWithSingleTaskInstanceAndReachedMilestoneAndEvent() {
        return ProcessInstanceStubs.createProcessWithSingleTaskInstanceAndReachedMilestoneAndEvent(Collections.emptySet());
    }

    public static ProcessInstance createProcessWithSingleTaskInstanceAndReachedMilestoneAndEvent(Set<ProcessData> processData) {
        return ProcessInstanceStubs.createProcessWithSingleTaskInstanceAndReachedMilestoneAndEventWithAdditionalMessages("template", Set.of(), processData, List.of());
    }

    public static ProcessInstance createProcessWithSingleTaskInstanceAndReachedMilestoneAndEventWithAdditionalMessages(String templateName, Set<TaskData> taskData, Set<ProcessData> processData, List<Message> additionalMessages) {
        TaskType taskType = TaskType.builder().name(task).lifecycle(TaskLifecycle.STATIC).cardinality(TaskCardinality.SINGLE_INSTANCE).taskData(taskData).build();
        ProcessTemplate processTemplate = ProcessTemplate.builder().name(templateName).templateHash("hash").taskTypes(Collections.singletonList(taskType)).milestones(Map.of(milestone, alwaysTrueMilestoneCondition, neverReachedMilestone, neverTrueMilestoneCondition)).build();
        ProcessInstance processInstance = ProcessInstance.startProcess((String)Generators.timeBasedEpochGenerator().generate().toString(), (ProcessTemplate)processTemplate, processData);
        Message message = Message.messageBuilder().messageName(event).messageId("eventId").idempotenceId("idempotenceId").originTaskIds(OriginTaskId.from((String)templateName, Set.of("taskId1", "taskId2"))).messageData(Set.of(new MessageData(templateName, "myKey", "myValue"))).createdAt(ZonedDateTime.now()).build();
        processInstance.addMessage(message);
        additionalMessages.forEach(arg_0 -> ((ProcessInstance)processInstance).addMessage(arg_0));
        processInstance.evaluateReachedMilestones();
        return processInstance;
    }

    public static Milestone createMilestone(String name, boolean reached) {
        Milestone milestone = Milestone.createNew((String)name, (MilestoneCondition)alwaysTrueMilestoneCondition, (ProcessInstance)ProcessInstanceStubs.createProcessWithSingleTaskInstance());
        if (reached) {
            milestone.evaluateIfReached(null);
        }
        return milestone;
    }

    public static TaskInstance createTaskInstance(String name, int index, String originTaskId) {
        TaskType taskType = TaskType.builder().name(name).lifecycle(TaskLifecycle.DYNAMIC).cardinality(TaskCardinality.MULTI_INSTANCE).index(index).build();
        return TaskInstance.createTaskInstanceWithOriginTaskId((TaskType)taskType, null, (String)originTaskId, (ZonedDateTime)ZonedDateTime.now(), null);
    }

    public static ProcessInstance createProcessWithEventDataProcessDataAndRelations(MessageRepository messageRepository) {
        TaskType firstTask = TaskType.builder().name(task).lifecycle(TaskLifecycle.STATIC).cardinality(TaskCardinality.SINGLE_INSTANCE).build();
        ProcessDataTemplate processDataTemplate1 = ProcessDataTemplate.builder().key("targetKeyName").sourceMessageName("sourceEventName").sourceMessageDataKey("sourceEventDataKey").build();
        ProcessDataTemplate processDataTemplate2 = ProcessDataTemplate.builder().key("targetKeyName").sourceMessageName("sourceEventName").sourceMessageDataKey("sourceEventDataKey").build();
        ProcessDataTemplate processDataTemplate3 = ProcessDataTemplate.builder().key("anotherTargetKeyName").sourceMessageName("anotherSourceEventName").sourceMessageDataKey("anotherSourceEventDataKey").build();
        RelationPattern relationPattern1 = RelationPattern.builder().objectSelector(RelationNodeSelector.builder().processDataKey("targetKeyName").processDataRole("someRole").type("ch.admin.bit.entity.Some").build()).subjectSelector(RelationNodeSelector.builder().processDataKey("targetKeyName").processDataRole("someOtherRole").type("ch.admin.bit.entity.Other").build()).predicateType("ch.admin.bit.test.predicate.Declares").build();
        RelationPattern relationPattern2 = RelationPattern.builder().objectSelector(RelationNodeSelector.builder().processDataKey("targetKeyName").type("ch.admin.bit.entity.Foo").build()).subjectSelector(RelationNodeSelector.builder().processDataKey("anotherTargetKeyName").type("ch.admin.bit.entity.Bar").build()).predicateType("ch.admin.bit.test.predicate.Knows").build();
        ProcessTemplate processTemplate = ProcessTemplate.builder().name("template").templateHash("hash").taskTypes(List.of(firstTask)).processDataTemplates(List.of(processDataTemplate1, processDataTemplate2, processDataTemplate3)).relationSystemId("ch.admin.test.System").relationPatterns(List.of(relationPattern1, relationPattern2)).build();
        ProcessInstance processInstance = ProcessInstance.startProcess((String)Generators.timeBasedEpochGenerator().generate().toString(), (ProcessTemplate)processTemplate, Collections.emptySet());
        String templateName = processInstance.getProcessTemplateName();
        MessageData messageData1 = new MessageData(templateName, "sourceEventDataKey", "someValue", "someRole");
        MessageData messageData2 = new MessageData(templateName, "sourceEventDataKey", "someValueOtherValue", "someOtherRole");
        MessageData messageData3 = new MessageData(templateName, "anotherSourceEventDataKey", "anotherValue");
        Message message = messageRepository.save(Message.messageBuilder().messageName("sourceEventName").messageId(Generators.timeBasedEpochGenerator().generate().toString()).idempotenceId(Generators.timeBasedEpochGenerator().generate().toString()).createdAt(ZonedDateTime.now()).messageData(Set.of(messageData1, messageData2)).traceId("traceId1").build());
        Message anotherMessage = messageRepository.save(Message.messageBuilder().messageName("anotherSourceEventName").messageId(Generators.timeBasedEpochGenerator().generate().toString()).idempotenceId(Generators.timeBasedEpochGenerator().generate().toString()).createdAt(ZonedDateTime.now()).messageData(Set.of(messageData3)).traceId("traceId2").build());
        processInstance.addMessage(message);
        processInstance.addMessage(anotherMessage);
        processInstance.evaluateRelations();
        return processInstance;
    }

    public static ProcessInstance createCompletedProcessInstance() {
        ProcessInstance processInstance = ProcessInstanceStubs.createProcessWithSingleTaskInstance("template", Collections.emptySet());
        ((TaskInstance)processInstance.getTasks().get(0)).complete(ZonedDateTime.now());
        processInstance.evaluateCompletedTasks(ZonedDateTime.now());
        Assertions.assertSame((Object)ProcessState.COMPLETED, (Object)processInstance.getState());
        return processInstance;
    }

    @Generated
    private ProcessInstanceStubs() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

