/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.message;

import ch.admin.bit.jeap.processcontext.domain.ImmutableDomainEntity;
import ch.admin.bit.jeap.processcontext.domain.message.MessageData;
import ch.admin.bit.jeap.processcontext.domain.message.MessageUserData;
import ch.admin.bit.jeap.processcontext.domain.message.OriginTaskId;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

@Entity(name="events")
@Table(name="events")
public class Message
extends ImmutableDomainEntity {
    @Id
    @NotNull
    private UUID id = Generators.timeBasedEpochGenerator().generate();
    @NotNull
    @Column(name="event_id")
    private String messageId;
    @NotNull
    private String idempotenceId;
    @NotNull
    @Column(name="event_name")
    private String messageName;
    @NotNull
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="events_event_data")
    private Set<MessageData> messageData;
    @NotNull
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="events_user_data")
    private Set<MessageUserData> userData;
    @NotNull
    @ElementCollection(fetch=FetchType.EAGER)
    private Set<OriginTaskId> originTaskIds;
    @Column(name="event_created_at")
    private ZonedDateTime messageCreatedAt;
    @Column(name="trace_id")
    private String traceId;

    private static Message createMessage(@NonNull String messageId, @NonNull String idempotenceId, @NonNull String messageName, Set<MessageData> messageData, Set<MessageUserData> userData, Set<OriginTaskId> originTaskIds, ZonedDateTime createdAt, ZonedDateTime messageCreatedAt, String traceId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        if (idempotenceId == null) {
            throw new NullPointerException("idempotenceId is marked non-null but is null");
        }
        if (messageName == null) {
            throw new NullPointerException("messageName is marked non-null but is null");
        }
        return new Message(messageId, idempotenceId, messageName, messageData, userData, originTaskIds, createdAt, messageCreatedAt, traceId);
    }

    public Set<MessageData> getMessageData(String templateName) {
        return this.getMessageData().stream().filter(templateMessageData -> templateMessageData.getTemplateName().equals(templateName)).collect(Collectors.toSet());
    }

    public Set<OriginTaskId> getOriginTaskIds(String templateName) {
        return this.getOriginTaskIds().stream().filter(templateOriginTaskId -> templateOriginTaskId.getTemplateName().equals(templateName)).collect(Collectors.toSet());
    }

    public Set<MessageData> getMessageData() {
        return Collections.unmodifiableSet(this.messageData);
    }

    public Set<OriginTaskId> getOriginTaskIds() {
        return Collections.unmodifiableSet(this.originTaskIds);
    }

    public ZonedDateTime getReceivedAt() {
        return this.getCreatedAt();
    }

    private Message(String messageId, String idempotenceId, String messageName, Set<MessageData> messageData, Set<MessageUserData> userData, Set<OriginTaskId> originTaskIds, ZonedDateTime createdAt, ZonedDateTime messageCreatedAt, String traceId) {
        this.messageId = messageId;
        this.idempotenceId = idempotenceId;
        this.messageName = messageName;
        this.messageData = messageData != null ? new HashSet<MessageData>(messageData) : Collections.emptySet();
        this.userData = userData != null ? new HashSet<MessageUserData>(userData) : Collections.emptySet();
        this.originTaskIds = originTaskIds != null ? new HashSet<OriginTaskId>(originTaskIds) : Collections.emptySet();
        this.createdAt = createdAt;
        this.messageCreatedAt = messageCreatedAt;
        this.traceId = traceId;
    }

    @Generated
    public static MessageBuilder messageBuilder() {
        return new MessageBuilder();
    }

    @Generated
    protected Message() {
    }

    @Generated
    public String toString() {
        return "Message(id=" + String.valueOf(this.getId()) + ", messageId=" + this.getMessageId() + ", idempotenceId=" + this.getIdempotenceId() + ", messageName=" + this.getMessageName() + ", messageData=" + String.valueOf(this.getMessageData()) + ", userData=" + String.valueOf(this.getUserData()) + ", originTaskIds=" + String.valueOf(this.getOriginTaskIds()) + ", messageCreatedAt=" + String.valueOf(this.getMessageCreatedAt()) + ", traceId=" + this.getTraceId() + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Generated
    public String getIdempotenceId() {
        return this.idempotenceId;
    }

    @Generated
    public String getMessageName() {
        return this.messageName;
    }

    @Generated
    public Set<MessageUserData> getUserData() {
        return this.userData;
    }

    @Generated
    public ZonedDateTime getMessageCreatedAt() {
        return this.messageCreatedAt;
    }

    @Generated
    public String getTraceId() {
        return this.traceId;
    }

    @Generated
    public static class MessageBuilder {
        @Generated
        private String messageId;
        @Generated
        private String idempotenceId;
        @Generated
        private String messageName;
        @Generated
        private Set<MessageData> messageData;
        @Generated
        private Set<MessageUserData> userData;
        @Generated
        private Set<OriginTaskId> originTaskIds;
        @Generated
        private ZonedDateTime createdAt;
        @Generated
        private ZonedDateTime messageCreatedAt;
        @Generated
        private String traceId;

        @Generated
        MessageBuilder() {
        }

        @Generated
        public MessageBuilder messageId(@NonNull String messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
            return this;
        }

        @Generated
        public MessageBuilder idempotenceId(@NonNull String idempotenceId) {
            if (idempotenceId == null) {
                throw new NullPointerException("idempotenceId is marked non-null but is null");
            }
            this.idempotenceId = idempotenceId;
            return this;
        }

        @Generated
        public MessageBuilder messageName(@NonNull String messageName) {
            if (messageName == null) {
                throw new NullPointerException("messageName is marked non-null but is null");
            }
            this.messageName = messageName;
            return this;
        }

        @Generated
        public MessageBuilder messageData(Set<MessageData> messageData) {
            this.messageData = messageData;
            return this;
        }

        @Generated
        public MessageBuilder userData(Set<MessageUserData> userData) {
            this.userData = userData;
            return this;
        }

        @Generated
        public MessageBuilder originTaskIds(Set<OriginTaskId> originTaskIds) {
            this.originTaskIds = originTaskIds;
            return this;
        }

        @Generated
        public MessageBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public MessageBuilder messageCreatedAt(ZonedDateTime messageCreatedAt) {
            this.messageCreatedAt = messageCreatedAt;
            return this;
        }

        @Generated
        public MessageBuilder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        @Generated
        public Message build() {
            return Message.createMessage(this.messageId, this.idempotenceId, this.messageName, this.messageData, this.userData, this.originTaskIds, this.createdAt, this.messageCreatedAt, this.traceId);
        }

        @Generated
        public String toString() {
            return "Message.MessageBuilder(messageId=" + this.messageId + ", idempotenceId=" + this.idempotenceId + ", messageName=" + this.messageName + ", messageData=" + String.valueOf(this.messageData) + ", userData=" + String.valueOf(this.userData) + ", originTaskIds=" + String.valueOf(this.originTaskIds) + ", createdAt=" + String.valueOf(this.createdAt) + ", messageCreatedAt=" + String.valueOf(this.messageCreatedAt) + ", traceId=" + this.traceId + ")";
        }
    }
}

