/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processinstance;

import ch.admin.bit.jeap.processcontext.domain.processinstance.MessageReferenceMessageDTO;
import ch.admin.bit.jeap.processcontext.domain.processinstance.MessageReferenceMessageDataDTO;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstance;
import ch.admin.bit.jeap.processcontext.domain.processinstance.TaskInstance;
import ch.admin.bit.jeap.processcontext.plugin.api.context.Message;
import ch.admin.bit.jeap.processcontext.plugin.api.context.ProcessCompletion;
import ch.admin.bit.jeap.processcontext.plugin.api.context.ProcessCompletionConclusion;
import ch.admin.bit.jeap.processcontext.plugin.api.context.ProcessContext;
import ch.admin.bit.jeap.processcontext.plugin.api.context.ProcessState;
import ch.admin.bit.jeap.processcontext.plugin.api.context.Task;
import ch.admin.bit.jeap.processcontext.plugin.api.context.TaskCardinality;
import ch.admin.bit.jeap.processcontext.plugin.api.context.TaskLifecycle;
import ch.admin.bit.jeap.processcontext.plugin.api.context.TaskState;
import ch.admin.bit.jeap.processcontext.plugin.api.context.TaskType;
import ch.admin.bit.jeap.processcontext.plugin.api.event.MessageData;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

final class ProcessContextFactory {
    static ProcessContext createProcessContext(ProcessInstance processInstance) {
        return ProcessContext.builder().originProcessId(processInstance.getOriginProcessId()).processName(processInstance.getProcessTemplateName()).processState(ProcessState.valueOf((String)processInstance.getState().name())).tasks(ProcessContextFactory.createTasks(processInstance.getTasks().stream().filter(t -> t.getTaskType().isPresent()).toList())).messages(ProcessContextFactory.createMessages(processInstance)).processCompletion(ProcessContextFactory.createProcessCompletion(processInstance)).build();
    }

    public static Message createMessage(MessageReferenceMessageDTO messageReferenceMessageDTO) {
        return Message.builder().name(messageReferenceMessageDTO.getMessageName()).relatedOriginTaskIds(messageReferenceMessageDTO.getRelatedOriginTaskIds()).messageData(ProcessContextFactory.toMessageData(messageReferenceMessageDTO.getMessageData())).build();
    }

    private static List<Task> createTasks(List<TaskInstance> tasks) {
        return tasks.stream().map(ProcessContextFactory::createTask).collect(Collectors.toList());
    }

    private static Task createTask(TaskInstance task) {
        TaskType taskType = TaskType.builder().name(task.requireTaskType().getName()).lifecycle(TaskLifecycle.valueOf((String)task.requireTaskType().getLifecycle().name())).cardinality(TaskCardinality.valueOf((String)task.requireTaskType().getCardinality().name())).build();
        return Task.builder().id(task.getId().toString()).originTaskId(task.getOriginTaskId()).type(taskType).state(TaskState.valueOf((String)task.getState().name())).build();
    }

    private static List<Message> createMessages(ProcessInstance processInstance) {
        return processInstance.getMessageReferences().stream().map(ProcessContextFactory::createMessage).collect(Collectors.toList());
    }

    private static Set<MessageData> toMessageData(Set<MessageReferenceMessageDataDTO> messageReferenceMessageDataDTOS) {
        return messageReferenceMessageDataDTOS.stream().map(data -> new MessageData(data.getMessageDataKey(), data.getMessageDataValue(), data.getMessageDataRole())).collect(Collectors.toSet());
    }

    private static ProcessCompletion createProcessCompletion(ProcessInstance processInstance) {
        return processInstance.getProcessCompletion().map(c -> ProcessCompletion.builder().conclusion(ProcessCompletionConclusion.valueOf((String)c.getConclusion().name())).completedAt(c.getCompletedAt()).name(c.getName()).build()).orElse(null);
    }

    @Generated
    private ProcessContextFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

