/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processupdate;

import ch.admin.bit.jeap.processcontext.domain.message.Message;
import ch.admin.bit.jeap.processcontext.domain.port.InternalMessageProducer;
import ch.admin.bit.jeap.processcontext.domain.processupdate.ProcessUpdate;
import ch.admin.bit.jeap.processcontext.domain.processupdate.ProcessUpdateRepository;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class ProcessUpdateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessUpdateService.class);
    private final InternalMessageProducer internalMessageProducer;
    private final ProcessUpdateRepository processUpdateRepository;
    private final PlatformTransactionManager transactionManager;

    public void createProcessReceived(String originProcessId, String template, Message message) {
        this.withinTransaction(() -> this.createAndSaveCreateProcessIfNeeded(originProcessId, message, template));
        this.internalMessageProducer.produceProcessContextOutdatedEventSynchronously(originProcessId);
        log.info("CreateProcess message {} for {} received", (Object)StructuredArguments.keyValue((String)"messageName", (Object)message.getMessageName()), (Object)StructuredArguments.keyValue((String)"originProcessId", (Object)originProcessId));
    }

    public void messageReceived(String originProcessId, Message message) {
        this.withinTransaction(() -> this.createAndSaveMessageIfNeeded(originProcessId, message));
        this.internalMessageProducer.produceProcessContextOutdatedEventSynchronously(originProcessId);
        log.info("Message {} for {} received", (Object)StructuredArguments.keyValue((String)"messageName", (Object)message.getMessageName()), (Object)StructuredArguments.keyValue((String)"originProcessId", (Object)originProcessId));
    }

    private void createAndSaveMessageIfNeeded(String originProcessId, Message message) {
        String idempotenceId;
        String messageName = message.getMessageName();
        if (this.processUpdateRepository.findByOriginProcessIdAndMessageNameAndIdempotenceId(originProcessId, messageName, idempotenceId = message.getIdempotenceId()).isPresent()) {
            log.info("Message {} {} has already been received for process {}.", new Object[]{StructuredArguments.keyValue((String)"messageName", (Object)messageName), StructuredArguments.keyValue((String)"idempotenceId", (Object)idempotenceId), StructuredArguments.keyValue((String)"originProcessId", (Object)originProcessId)});
        } else {
            ProcessUpdate processUpdate = ProcessUpdate.messageReceived().originProcessId(originProcessId).messageReference(message.getId()).messageName(messageName).idempotenceId(idempotenceId).build();
            this.processUpdateRepository.save(processUpdate);
        }
    }

    private void createAndSaveCreateProcessIfNeeded(String originProcessId, Message message, String template) {
        String idempotenceId;
        String messageName = message.getMessageName();
        if (this.processUpdateRepository.findByOriginProcessIdAndMessageNameAndIdempotenceId(originProcessId, messageName, idempotenceId = message.getIdempotenceId()).isPresent()) {
            log.info("CreateProcess message {} {} has already been received for process {}.", new Object[]{StructuredArguments.keyValue((String)"messageName", (Object)messageName), StructuredArguments.keyValue((String)"idempotenceId", (Object)idempotenceId), StructuredArguments.keyValue((String)"originProcessId", (Object)originProcessId)});
        } else {
            ProcessUpdate processUpdate = ProcessUpdate.createProcessReceived().originProcessId(originProcessId).template(template).messageReference(message.getId()).messageName(messageName).idempotenceId(idempotenceId).build();
            this.processUpdateRepository.save(processUpdate);
        }
    }

    private void withinTransaction(Runnable callback) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.executeWithoutResult(status -> callback.run());
    }

    @Generated
    public ProcessUpdateService(InternalMessageProducer internalMessageProducer, ProcessUpdateRepository processUpdateRepository, PlatformTransactionManager transactionManager) {
        this.internalMessageProducer = internalMessageProducer;
        this.processUpdateRepository = processUpdateRepository;
        this.transactionManager = transactionManager;
    }
}

