/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.message;

import jakarta.persistence.Embeddable;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

@Embeddable
public class OriginTaskId {
    @NotNull
    private String templateName;
    @NotNull
    private String originTaskId;

    OriginTaskId(String templateName, String originTaskId) {
        Objects.requireNonNull(templateName, "Template name is mandatory.");
        Objects.requireNonNull(originTaskId, "Origin task id is mandatory.");
        this.templateName = templateName;
        this.originTaskId = originTaskId;
    }

    public static OriginTaskId from(String templateName, String originTaskId) {
        return new OriginTaskId(templateName, originTaskId);
    }

    public static Set<OriginTaskId> from(String templateName, Collection<String> originTaskIds) {
        return originTaskIds.stream().map(originTaskId -> OriginTaskId.from(templateName, originTaskId)).collect(Collectors.toSet());
    }

    @Generated
    protected OriginTaskId() {
    }

    @Generated
    public String getTemplateName() {
        return this.templateName;
    }

    @Generated
    public String getOriginTaskId() {
        return this.originTaskId;
    }

    @Generated
    public String toString() {
        return "OriginTaskId(templateName=" + this.getTemplateName() + ", originTaskId=" + this.getOriginTaskId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OriginTaskId)) {
            return false;
        }
        OriginTaskId other = (OriginTaskId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$templateName = this.getTemplateName();
        String other$templateName = other.getTemplateName();
        if (this$templateName == null ? other$templateName != null : !this$templateName.equals(other$templateName)) {
            return false;
        }
        String this$originTaskId = this.getOriginTaskId();
        String other$originTaskId = other.getOriginTaskId();
        return !(this$originTaskId == null ? other$originTaskId != null : !this$originTaskId.equals(other$originTaskId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OriginTaskId;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $templateName = this.getTemplateName();
        result = result * 59 + ($templateName == null ? 43 : $templateName.hashCode());
        String $originTaskId = this.getOriginTaskId();
        result = result * 59 + ($originTaskId == null ? 43 : $originTaskId.hashCode());
        return result;
    }
}

