/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processevent;

import ch.admin.bit.jeap.processcontext.domain.port.MetricsListener;
import ch.admin.bit.jeap.processcontext.domain.port.ProcessInstanceEventProducer;
import ch.admin.bit.jeap.processcontext.domain.processevent.EventType;
import ch.admin.bit.jeap.processcontext.domain.processevent.ProcessEvent;
import ch.admin.bit.jeap.processcontext.domain.processevent.ProcessEventRepository;
import ch.admin.bit.jeap.processcontext.domain.processevent.RelationMapper;
import ch.admin.bit.jeap.processcontext.domain.processinstance.NotFoundException;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstance;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstanceQueryRepository;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessState;
import ch.admin.bit.jeap.processcontext.domain.processinstance.Relation;
import ch.admin.bit.jeap.processcontext.plugin.api.relation.RelationListener;
import io.micrometer.core.annotation.Timed;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ProcessEventService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessEventService.class);
    private final ProcessInstanceQueryRepository processInstanceQueryRepository;
    private final ProcessEventRepository processEventRepository;
    private final ProcessInstanceEventProducer processInstanceEventProducer;
    private final RelationListener relationListener;
    private final MetricsListener metricsListener;

    @Transactional
    @Timed(value="jeap_pcs_react_to_process_state_change", description="Produce new process events", percentiles={0.5, 0.8, 0.95, 0.99})
    public void reactToProcessStateChange(String originProcessId) {
        Map<EventType, List<ProcessEvent>> previouslyProducedEventsByType = this.findPreviouslyProducedEvents(originProcessId);
        List<ProcessEvent> newProducedEvents = this.produceProcessEvents(originProcessId, previouslyProducedEventsByType);
        this.processEventRepository.saveAll(newProducedEvents);
    }

    private List<ProcessEvent> produceProcessEvents(String originProcessId, Map<EventType, List<ProcessEvent>> producedEvents) {
        ProcessInstance processInstance = this.processInstanceQueryRepository.findByOriginProcessIdWithoutLoadingMessages(originProcessId).orElseThrow(NotFoundException.processNotFound(originProcessId));
        log.debug("Producing process events for process instance {}", (Object)processInstance.toString());
        String processName = processInstance.getProcessTemplateName();
        ArrayList<ProcessEvent> events = new ArrayList<ProcessEvent>();
        this.metricsListener.timed("jeap_pcs_produce_process_state_changed_events", Map.of(), () -> this.produceProcessStateEvents(originProcessId, producedEvents, processInstance, processName, events));
        this.metricsListener.timed("jeap_pcs_produce_milestone_events", Map.of(), () -> this.produceMilestoneNotifications(originProcessId, producedEvents, processInstance, events));
        this.metricsListener.timed("jeap_pcs_produce_relation_events", Map.of(), () -> this.produceRelationNotifications(originProcessId, producedEvents, processInstance, events));
        this.metricsListener.timed("jeap_pcs_produce_snapshot_events", Map.of(), () -> this.produceSnapshotNotifications(originProcessId, producedEvents, processInstance, events));
        events.forEach(event -> this.metricsListener.processEventCreated(processInstance.getProcessTemplate(), event.getEventType()));
        return events;
    }

    private void produceProcessStateEvents(String originProcessId, Map<EventType, List<ProcessEvent>> producedEvents, ProcessInstance processInstance, String processName, List<ProcessEvent> events) {
        boolean isProcessStartedProduced = producedEvents.containsKey((Object)EventType.PROCESS_STARTED);
        if (!isProcessStartedProduced) {
            log.debug("Producing process instance created event for process {}", (Object)originProcessId);
            this.processInstanceEventProducer.produceProcessInstanceCreatedEventSynchronously(originProcessId, processName);
            events.add(ProcessEvent.createProcessStarted(originProcessId));
        }
        boolean isProcessCompletedProduced = producedEvents.containsKey((Object)EventType.PROCESS_COMPLETED);
        if (processInstance.getState() == ProcessState.COMPLETED && !isProcessCompletedProduced) {
            log.debug("Producing process instance completed event for process {}", (Object)originProcessId);
            this.metricsListener.processCompleted(processInstance.getProcessTemplate());
            this.processInstanceEventProducer.produceProcessInstanceCompletedEventSynchronously(originProcessId);
            events.add(ProcessEvent.createProcessCompleted(originProcessId));
        }
    }

    private void produceRelationNotifications(String originProcessId, Map<EventType, List<ProcessEvent>> producedEvents, ProcessInstance processInstance, List<ProcessEvent> events) {
        Map<String, Relation> relations = processInstance.getRelations().stream().collect(Collectors.toMap(r -> r.getIdempotenceId().toString(), r -> r));
        Set notifiedRelations = producedEvents.getOrDefault((Object)EventType.RELATION_ADDED, List.of()).stream().map(ProcessEvent::getName).collect(Collectors.toSet());
        relations.keySet().removeAll(notifiedRelations);
        if (!relations.isEmpty()) {
            log.debug("Notifying relation listener, relations added: {}", relations);
            this.metricsListener.timed("jeap_pcs_notify_relations_added", Map.of("relationsCount", Integer.toString(relations.size())), () -> this.relationListener.relationsAdded(relations.values().stream().map(relation -> RelationMapper.toApiObject(originProcessId, relation)).toList()));
            events.addAll(relations.values().stream().map(relation -> ProcessEvent.createRelationAdded(originProcessId, relation.getIdempotenceId())).toList());
        }
    }

    private void produceMilestoneNotifications(String originProcessId, Map<EventType, List<ProcessEvent>> producedEvents, ProcessInstance processInstance, List<ProcessEvent> events) {
        Set<String> reachedMilestones = processInstance.getReachedMilestones();
        Set milestonesWithProducedEvent = producedEvents.getOrDefault((Object)EventType.MILESTONE_REACHED, List.of()).stream().map(ProcessEvent::getName).collect(Collectors.toSet());
        HashSet<String> milestonesRequiringEvent = new HashSet<String>(reachedMilestones);
        milestonesRequiringEvent.removeAll(milestonesWithProducedEvent);
        milestonesRequiringEvent.forEach(milestoneName -> {
            log.debug("Producing milestone reached event for milestone {} in process {}", milestoneName, (Object)originProcessId);
            this.metricsListener.milestoneReached(processInstance.getProcessTemplate(), (String)milestoneName);
            this.processInstanceEventProducer.produceProcessMilestoneReachedEventSynchronously(originProcessId, (String)milestoneName);
            events.add(ProcessEvent.createMilestoneReached(originProcessId, milestoneName));
        });
    }

    private void produceSnapshotNotifications(String originProcessId, Map<EventType, List<ProcessEvent>> producedEvents, ProcessInstance processInstance, List<ProcessEvent> events) {
        Set snapshotsWithProducedEvent = producedEvents.getOrDefault((Object)EventType.SNAPSHOT_CREATED, List.of()).stream().map(ProcessEvent::getName).collect(Collectors.toSet());
        for (int version = 1; version <= processInstance.getLatestSnapshotVersion(); ++version) {
            String versionString = Integer.toString(version);
            if (snapshotsWithProducedEvent.contains(versionString)) continue;
            log.debug("Producing snapshot created event for snapshot version {} in process {}", (Object)versionString, (Object)originProcessId);
            this.processInstanceEventProducer.produceProcessSnapshotCreatedEventSynchronously(originProcessId, version);
            this.metricsListener.snapshotCreated(processInstance.getProcessTemplate());
            events.add(ProcessEvent.createSnapshotCreated(originProcessId, versionString));
        }
    }

    private Map<EventType, List<ProcessEvent>> findPreviouslyProducedEvents(String originProcessId) {
        return this.processEventRepository.findByOriginProcessId(originProcessId).stream().collect(Collectors.groupingBy(ProcessEvent::getEventType));
    }

    @Generated
    public ProcessEventService(ProcessInstanceQueryRepository processInstanceQueryRepository, ProcessEventRepository processEventRepository, ProcessInstanceEventProducer processInstanceEventProducer, RelationListener relationListener, MetricsListener metricsListener) {
        this.processInstanceQueryRepository = processInstanceQueryRepository;
        this.processEventRepository = processEventRepository;
        this.processInstanceEventProducer = processInstanceEventProducer;
        this.relationListener = relationListener;
        this.metricsListener = metricsListener;
    }
}

