/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processtemplate;

import ch.admin.bit.jeap.processcontext.domain.processtemplate.TaskCardinality;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.TaskData;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.TaskLifecycle;
import ch.admin.bit.jeap.processcontext.plugin.api.condition.TaskInstantiationCondition;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskType {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskType.class);
    private final String name;
    private final int index;
    private final TaskLifecycle lifecycle;
    private final TaskCardinality cardinality;
    private final String plannedByDomainEvent;
    private final String observesDomainEvent;
    private final String completedByDomainEvent;
    private final TaskInstantiationCondition instantiationCondition;
    private final Set<TaskData> taskData;

    private TaskType(@NonNull String name, int index, @NonNull TaskLifecycle lifecycle, @NonNull TaskCardinality cardinality, String plannedByDomainEvent, String completedByDomainEvent, String observesMessage, TaskInstantiationCondition instantiationCondition, Set<TaskData> taskData) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (lifecycle == null) {
            throw new NullPointerException("lifecycle is marked non-null but is null");
        }
        if (cardinality == null) {
            throw new NullPointerException("cardinality is marked non-null but is null");
        }
        this.name = name;
        this.index = index;
        this.lifecycle = lifecycle;
        this.cardinality = cardinality;
        this.completedByDomainEvent = completedByDomainEvent;
        this.plannedByDomainEvent = plannedByDomainEvent;
        this.observesDomainEvent = observesMessage;
        this.instantiationCondition = instantiationCondition;
        this.taskData = taskData != null ? Set.copyOf(taskData) : Set.of();
    }

    public boolean isValidInstanceCount(int count) {
        if (count < 0) {
            return false;
        }
        if (count == 0) {
            return this.lifecycle != TaskLifecycle.STATIC;
        }
        return this.cardinality == TaskCardinality.SINGLE_INSTANCE && count == 1 || this.cardinality == TaskCardinality.MULTI_INSTANCE;
    }

    public boolean isPlannedAtProcessStart() {
        return this.getLifecycle() == TaskLifecycle.STATIC;
    }

    @Generated
    public static TaskTypeBuilder builder() {
        return new TaskTypeBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public TaskLifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Generated
    public TaskCardinality getCardinality() {
        return this.cardinality;
    }

    @Generated
    public String getPlannedByDomainEvent() {
        return this.plannedByDomainEvent;
    }

    @Generated
    public String getObservesDomainEvent() {
        return this.observesDomainEvent;
    }

    @Generated
    public String getCompletedByDomainEvent() {
        return this.completedByDomainEvent;
    }

    @Generated
    public TaskInstantiationCondition getInstantiationCondition() {
        return this.instantiationCondition;
    }

    @Generated
    public Set<TaskData> getTaskData() {
        return this.taskData;
    }

    @Generated
    public String toString() {
        return "TaskType(name=" + this.getName() + ", index=" + this.getIndex() + ", lifecycle=" + String.valueOf((Object)this.getLifecycle()) + ", cardinality=" + String.valueOf((Object)this.getCardinality()) + ", plannedByDomainEvent=" + this.getPlannedByDomainEvent() + ", observesDomainEvent=" + this.getObservesDomainEvent() + ", completedByDomainEvent=" + this.getCompletedByDomainEvent() + ", instantiationCondition=" + String.valueOf(this.getInstantiationCondition()) + ", taskData=" + String.valueOf(this.getTaskData()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskType)) {
            return false;
        }
        TaskType other = (TaskType)o;
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public static class TaskTypeBuilder {
        @Generated
        private String name;
        @Generated
        private int index;
        @Generated
        private TaskLifecycle lifecycle;
        @Generated
        private TaskCardinality cardinality;
        @Generated
        private String plannedByDomainEvent;
        @Generated
        private String completedByDomainEvent;
        @Generated
        private String observesMessage;
        @Generated
        private TaskInstantiationCondition instantiationCondition;
        @Generated
        private Set<TaskData> taskData;

        @Generated
        TaskTypeBuilder() {
        }

        @Generated
        public TaskTypeBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public TaskTypeBuilder index(int index) {
            this.index = index;
            return this;
        }

        @Generated
        public TaskTypeBuilder lifecycle(@NonNull TaskLifecycle lifecycle) {
            if (lifecycle == null) {
                throw new NullPointerException("lifecycle is marked non-null but is null");
            }
            this.lifecycle = lifecycle;
            return this;
        }

        @Generated
        public TaskTypeBuilder cardinality(@NonNull TaskCardinality cardinality) {
            if (cardinality == null) {
                throw new NullPointerException("cardinality is marked non-null but is null");
            }
            this.cardinality = cardinality;
            return this;
        }

        @Generated
        public TaskTypeBuilder plannedByDomainEvent(String plannedByDomainEvent) {
            this.plannedByDomainEvent = plannedByDomainEvent;
            return this;
        }

        @Generated
        public TaskTypeBuilder completedByDomainEvent(String completedByDomainEvent) {
            this.completedByDomainEvent = completedByDomainEvent;
            return this;
        }

        @Generated
        public TaskTypeBuilder observesMessage(String observesMessage) {
            this.observesMessage = observesMessage;
            return this;
        }

        @Generated
        public TaskTypeBuilder instantiationCondition(TaskInstantiationCondition instantiationCondition) {
            this.instantiationCondition = instantiationCondition;
            return this;
        }

        @Generated
        public TaskTypeBuilder taskData(Set<TaskData> taskData) {
            this.taskData = taskData;
            return this;
        }

        @Generated
        public TaskType build() {
            return new TaskType(this.name, this.index, this.lifecycle, this.cardinality, this.plannedByDomainEvent, this.completedByDomainEvent, this.observesMessage, this.instantiationCondition, this.taskData);
        }

        @Generated
        public String toString() {
            return "TaskType.TaskTypeBuilder(name=" + this.name + ", index=" + this.index + ", lifecycle=" + String.valueOf((Object)this.lifecycle) + ", cardinality=" + String.valueOf((Object)this.cardinality) + ", plannedByDomainEvent=" + this.plannedByDomainEvent + ", completedByDomainEvent=" + this.completedByDomainEvent + ", observesMessage=" + this.observesMessage + ", instantiationCondition=" + String.valueOf(this.instantiationCondition) + ", taskData=" + String.valueOf(this.taskData) + ")";
        }
    }
}

