/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.message;

import ch.admin.bit.jeap.messaging.kafka.tracing.TraceContextProvider;
import ch.admin.bit.jeap.messaging.model.MessagePayload;
import ch.admin.bit.jeap.messaging.model.MessageReferences;
import ch.admin.bit.jeap.messaging.model.MessageUser;
import ch.admin.bit.jeap.processcontext.domain.message.Message;
import ch.admin.bit.jeap.processcontext.domain.message.MessageData;
import ch.admin.bit.jeap.processcontext.domain.message.MessageReceiver;
import ch.admin.bit.jeap.processcontext.domain.message.MessageRepository;
import ch.admin.bit.jeap.processcontext.domain.message.MessageUserData;
import ch.admin.bit.jeap.processcontext.domain.message.OriginTaskId;
import ch.admin.bit.jeap.processcontext.domain.port.MessageConsumerFactory;
import ch.admin.bit.jeap.processcontext.domain.port.MetricsListener;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstanceQueryRepository;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.CorrelatedByProcessData;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.MessageReference;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessTemplateRepository;
import ch.admin.bit.jeap.processcontext.domain.processupdate.ProcessUpdateService;
import ch.admin.bit.jeap.processcontext.plugin.api.event.EventData;
import ch.admin.bit.jeap.processcontext.plugin.api.event.PayloadExtractor;
import ch.admin.bit.jeap.processcontext.plugin.api.event.ReferenceExtractor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
class MessageService
implements MessageReceiver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageService.class);
    private final ProcessTemplateRepository processTemplateRepository;
    private final MessageConsumerFactory messageConsumerFactory;
    private final MessageRepository messageRepository;
    private final ProcessUpdateService processUpdateService;
    private final ProcessInstanceQueryRepository processInstanceQueryRepository;
    private final PlatformTransactionManager transactionManager;
    private final MetricsListener metricsListener;
    private final TraceContextProvider traceContextProvider;

    @EventListener
    public void onAppStarted(ApplicationStartedEvent event) {
        this.startDomainEventListeners();
    }

    void startDomainEventListeners() {
        Set<MessageDto> eventTopics = this.processTemplateRepository.getAllTemplates().stream().flatMap(template -> template.getMessageReferences().stream()).map(messageRef -> MessageDto.of(messageRef.getMessageName(), messageRef.getTopicName(), messageRef.getClusterName())).collect(Collectors.toSet());
        eventTopics.forEach(messageDto -> this.messageConsumerFactory.startConsumer(messageDto.getTopicName(), messageDto.getMessageName(), messageDto.getClusterName(), this));
    }

    @Override
    public void messageReceived(ch.admin.bit.jeap.messaging.model.Message message) {
        log.info("Received message: {}", (Object)message.getType().getName());
        this.metricsListener.timed("jeap_pcs_process_message", Map.of(), () -> this.processMessage(message));
        log.info("Processed message: {}", (Object)message.getType().getName());
    }

    private void processMessage(ch.admin.bit.jeap.messaging.model.Message message) {
        log.info("Processing message '{}'", (Object)message.getType().getName());
        HashSet templateMessageData = new HashSet();
        HashSet templateOriginTaskIds = new HashSet();
        Map<String, MessageReference> messageReferencesByTemplateNameForMessageName = this.processTemplateRepository.getMessageReferencesByTemplateNameForMessageName(message.getType().getName());
        messageReferencesByTemplateNameForMessageName.forEach((templateName, messageReference) -> {
            Set<ch.admin.bit.jeap.processcontext.plugin.api.event.MessageData> messageData = this.getMessageData(message, (MessageReference)messageReference);
            templateMessageData.addAll(MessageData.from(templateName, messageData));
            Set<String> originTaskIds = this.getRelatedOriginTaskIds(message, (MessageReference)messageReference);
            templateOriginTaskIds.addAll(OriginTaskId.from(templateName, originTaskIds));
        });
        Message messageEntity = this.withinTransaction(() -> this.createAndSaveMessageIfNeeded(message, templateMessageData, templateOriginTaskIds));
        HashSet<String> correlatedOriginProcessIds = new HashSet<String>();
        this.metricsListener.timed("jeap_pcs_early_correlate_message", Collections.emptyMap(), () -> {
            Set originProcessIds = this.withinReadOnlyTransaction(() -> this.correlateMessage(message, templateMessageData));
            correlatedOriginProcessIds.addAll(originProcessIds);
        });
        this.initiateProcessUpdatesForMessage(message, messageEntity, correlatedOriginProcessIds);
        log.info("Processed message '{}'", (Object)message.getType().getName());
    }

    private void initiateProcessUpdatesForMessage(ch.admin.bit.jeap.messaging.model.Message message, Message messageEntity, Set<String> originProcessIds) {
        originProcessIds.forEach(originProcessId -> {
            boolean createProcessNeeded = this.initiateCreateProcessIfNeeded(message, messageEntity, (String)originProcessId);
            if (!createProcessNeeded) {
                this.processUpdateService.messageReceived((String)originProcessId, messageEntity);
            }
        });
    }

    private boolean initiateCreateProcessIfNeeded(ch.admin.bit.jeap.messaging.model.Message message, Message messageEntity, String originProcessId) {
        Set<String> processTemplateNamesForInstantiation = this.getProcessTemplateNamesNeedingInstantiation(message);
        if (processTemplateNamesForInstantiation.isEmpty() || this.processInstanceQueryRepository.existsByOriginProcessId(originProcessId)) {
            return false;
        }
        if (processTemplateNamesForInstantiation.size() > 1) {
            log.error("Message '{}' is configured to start a process in more than one process template ({}). Cannot start more than one process for the same origin process id ({}). Skipping process creation. Make sure that the process instantiation conditions configured on the same message in different process templates compute mutual exclusive results.", new Object[]{messageEntity.getMessageName(), String.join((CharSequence)",", processTemplateNamesForInstantiation), originProcessId});
            return false;
        }
        processTemplateNamesForInstantiation.forEach(template -> this.processUpdateService.createProcessReceived(originProcessId, (String)template, messageEntity));
        return true;
    }

    private Set<String> getProcessTemplateNamesNeedingInstantiation(ch.admin.bit.jeap.messaging.model.Message message) {
        return this.processTemplateRepository.getMessageReferencesByTemplateNameForMessageName(message.getType().getName()).entrySet().stream().filter(entry -> ((MessageReference)entry.getValue()).getProcessInstantiationCondition().triggersProcessInstantiation(message)).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
    }

    private Message createAndSaveMessageIfNeeded(ch.admin.bit.jeap.messaging.model.Message message, Set<MessageData> messageData, Set<OriginTaskId> originTaskIds) {
        return this.messageRepository.findByMessageNameAndIdempotenceId(message.getType().getName(), message.getIdentity().getIdempotenceId()).map(messageEntity -> {
            this.metricsListener.messageReceived(message.getType(), false);
            return messageEntity;
        }).orElseGet(() -> {
            this.metricsListener.messageReceived(message.getType(), true);
            return this.saveMessage(message, messageData, originTaskIds, this.getTraceId());
        });
    }

    private Set<String> correlateMessage(ch.admin.bit.jeap.messaging.model.Message message, Set<MessageData> templateMessageData) {
        Map<String, MessageReference> messageReferencesByTemplateName = this.processTemplateRepository.getMessageReferencesByTemplateNameForMessageName(message.getType().getName());
        HashSet<String> originProcessIds = new HashSet<String>();
        messageReferencesByTemplateName.forEach((templateName, messageReference) -> {
            originProcessIds.addAll(this.getProcessIdsCorrelatedByCorrelationProvider(message, (MessageReference)messageReference));
            originProcessIds.addAll(this.getProcessIdsCorrelatedByProcessData((MessageReference)messageReference, templateMessageData, (String)templateName));
        });
        return originProcessIds;
    }

    private Set<String> getProcessIdsCorrelatedByProcessData(MessageReference messageReference, Set<MessageData> templateMessageData, String templateName) {
        CorrelatedByProcessData correlatedByProcessData = messageReference.getCorrelatedByProcessData();
        if (correlatedByProcessData == null) {
            return Collections.emptySet();
        }
        return templateMessageData.stream().filter(ed -> ed.getTemplateName().equals(templateName)).filter(ed -> correlatedByProcessData.getMessageDataKey().equals(ed.getKey())).map(ed -> this.processInstanceQueryRepository.findUncompletedProcessInstancesHavingProcessData(templateName, correlatedByProcessData.getProcessDataKey(), ed.getValue(), ed.getRole())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Message saveMessage(ch.admin.bit.jeap.messaging.model.Message message, Set<MessageData> messageData, Set<OriginTaskId> originTaskIds, String traceId) {
        Message newMessage = Message.messageBuilder().messageId(message.getIdentity().getId()).idempotenceId(message.getIdentity().getIdempotenceId()).traceId(traceId).messageName(message.getType().getName()).messageData(messageData).userData(this.getUserDataFromMessage(message)).originTaskIds(originTaskIds).messageCreatedAt(message.getIdentity().getCreatedZoned()).build();
        return this.messageRepository.save(newMessage);
    }

    private Set<MessageUserData> getUserDataFromMessage(ch.admin.bit.jeap.messaging.model.Message message) {
        HashSet<MessageUserData> userData = new HashSet<MessageUserData>();
        Optional optionalUser = message.getOptionalUser();
        if (optionalUser.isPresent()) {
            MessageUser messageUser = (MessageUser)optionalUser.get();
            this.addNullableField(userData, "id", messageUser.getId());
            this.addNullableField(userData, "familyName", messageUser.getFamilyName());
            this.addNullableField(userData, "givenName", messageUser.getGivenName());
            this.addNullableField(userData, "businessPartnerName", messageUser.getBusinessPartnerName());
            this.addNullableField(userData, "businessPartnerId", messageUser.getBusinessPartnerId());
            messageUser.getPropertiesMap().forEach((key, value) -> userData.add(new MessageUserData((String)key, (String)value)));
        }
        return userData;
    }

    private void addNullableField(Set<MessageUserData> userData, String key, String value) {
        if (value != null) {
            userData.add(new MessageUserData(key, value));
        }
    }

    private Set<String> getProcessIdsCorrelatedByCorrelationProvider(ch.admin.bit.jeap.messaging.model.Message message, MessageReference messageReference) {
        Set relatedOriginProcessIds = messageReference.getCorrelationProvider().getOriginProcessIds(message);
        log.debug("Related origin process ids extracted from message {}: {}", (Object)message.getType().getName(), (Object)relatedOriginProcessIds);
        return relatedOriginProcessIds;
    }

    private Set<String> getRelatedOriginTaskIds(ch.admin.bit.jeap.messaging.model.Message message, MessageReference messageReference) {
        Set relatedOriginTaskIds = messageReference.getCorrelationProvider().getRelatedOriginTaskIds(message);
        log.debug("Related origin task ids extracted from message {}: {}", (Object)message.getType().getName(), (Object)relatedOriginTaskIds);
        return relatedOriginTaskIds;
    }

    private Set<ch.admin.bit.jeap.processcontext.plugin.api.event.MessageData> getMessageData(ch.admin.bit.jeap.messaging.model.Message message, MessageReference messageReference) {
        HashSet<ch.admin.bit.jeap.processcontext.plugin.api.event.MessageData> messageData = new HashSet<ch.admin.bit.jeap.processcontext.plugin.api.event.MessageData>(this.getMessageDataFromPayload(message, messageReference));
        messageData.addAll(this.getMessageDataFromReferences(message, messageReference));
        return messageData;
    }

    private Set<ch.admin.bit.jeap.processcontext.plugin.api.event.MessageData> getMessageDataFromPayload(ch.admin.bit.jeap.messaging.model.Message message, MessageReference messageReference) {
        Optional optionalPayload = message.getOptionalPayload();
        if (optionalPayload.isEmpty()) {
            return Collections.emptySet();
        }
        PayloadExtractor<MessagePayload> payloadExtractor = messageReference.getPayloadExtractor();
        MessagePayload payload = (MessagePayload)optionalPayload.get();
        Set eventData = payloadExtractor.getEventData(payload).stream().map(EventData::toMessageData).collect(Collectors.toSet());
        Set messageData = payloadExtractor.getMessageData(payload);
        HashSet<ch.admin.bit.jeap.processcontext.plugin.api.event.MessageData> data = new HashSet<ch.admin.bit.jeap.processcontext.plugin.api.event.MessageData>(messageData);
        data.addAll(eventData);
        log.debug("Message data extracted from payload of message {}: {}", (Object)message.getType().getName(), data);
        return data;
    }

    private Set<ch.admin.bit.jeap.processcontext.plugin.api.event.MessageData> getMessageDataFromReferences(ch.admin.bit.jeap.messaging.model.Message message, MessageReference messageReference) {
        MessageReferences messageReferences = message.getOptionalReferences().orElse(null);
        if (messageReferences == null) {
            return Collections.emptySet();
        }
        ReferenceExtractor<MessageReferences> referenceExtractor = messageReference.getReferenceExtractor();
        Set eventData = referenceExtractor.getEventData(messageReferences).stream().map(EventData::toMessageData).collect(Collectors.toSet());
        Set messageData = referenceExtractor.getMessageData(messageReferences);
        HashSet<ch.admin.bit.jeap.processcontext.plugin.api.event.MessageData> data = new HashSet<ch.admin.bit.jeap.processcontext.plugin.api.event.MessageData>(messageData);
        data.addAll(eventData);
        log.debug("Message data extracted from reference of message {}: {}", (Object)message.getType().getName(), data);
        return data;
    }

    private <T> T withinTransaction(Supplier<T> callable) {
        return this.withinTransaction(callable, false);
    }

    private <T> T withinReadOnlyTransaction(Supplier<T> callable) {
        return this.withinTransaction(callable, true);
    }

    private <T> T withinTransaction(Supplier<T> callable, boolean readOnly) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setReadOnly(readOnly);
        return (T)transactionTemplate.execute(status -> callable.get());
    }

    private String getTraceId() {
        return this.traceContextProvider.getTraceContext() != null ? this.traceContextProvider.getTraceContext().getTraceIdString() : null;
    }

    @Generated
    public MessageService(ProcessTemplateRepository processTemplateRepository, MessageConsumerFactory messageConsumerFactory, MessageRepository messageRepository, ProcessUpdateService processUpdateService, ProcessInstanceQueryRepository processInstanceQueryRepository, PlatformTransactionManager transactionManager, MetricsListener metricsListener, TraceContextProvider traceContextProvider) {
        this.processTemplateRepository = processTemplateRepository;
        this.messageConsumerFactory = messageConsumerFactory;
        this.messageRepository = messageRepository;
        this.processUpdateService = processUpdateService;
        this.processInstanceQueryRepository = processInstanceQueryRepository;
        this.transactionManager = transactionManager;
        this.metricsListener = metricsListener;
        this.traceContextProvider = traceContextProvider;
    }

    private static final class MessageDto {
        @NonNull
        private final String messageName;
        @NonNull
        private final String topicName;
        private final String clusterName;

        @Generated
        private MessageDto(@NonNull String messageName, @NonNull String topicName, String clusterName) {
            if (messageName == null) {
                throw new NullPointerException("messageName is marked non-null but is null");
            }
            if (topicName == null) {
                throw new NullPointerException("topicName is marked non-null but is null");
            }
            this.messageName = messageName;
            this.topicName = topicName;
            this.clusterName = clusterName;
        }

        @Generated
        public static MessageDto of(@NonNull String messageName, @NonNull String topicName, String clusterName) {
            if (messageName == null) {
                throw new NullPointerException("messageName is marked non-null but is null");
            }
            if (topicName == null) {
                throw new NullPointerException("topicName is marked non-null but is null");
            }
            return new MessageDto(messageName, topicName, clusterName);
        }

        @NonNull
        @Generated
        public String getMessageName() {
            return this.messageName;
        }

        @NonNull
        @Generated
        public String getTopicName() {
            return this.topicName;
        }

        @Generated
        public String getClusterName() {
            return this.clusterName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MessageDto)) {
                return false;
            }
            MessageDto other = (MessageDto)o;
            String this$messageName = this.getMessageName();
            String other$messageName = other.getMessageName();
            if (this$messageName == null ? other$messageName != null : !this$messageName.equals(other$messageName)) {
                return false;
            }
            String this$topicName = this.getTopicName();
            String other$topicName = other.getTopicName();
            if (this$topicName == null ? other$topicName != null : !this$topicName.equals(other$topicName)) {
                return false;
            }
            String this$clusterName = this.getClusterName();
            String other$clusterName = other.getClusterName();
            return !(this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $messageName = this.getMessageName();
            result = result * 59 + ($messageName == null ? 43 : $messageName.hashCode());
            String $topicName = this.getTopicName();
            result = result * 59 + ($topicName == null ? 43 : $topicName.hashCode());
            String $clusterName = this.getClusterName();
            result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MessageService.MessageDto(messageName=" + this.getMessageName() + ", topicName=" + this.getTopicName() + ", clusterName=" + this.getClusterName() + ")";
        }
    }
}

