/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processinstance;

import ch.admin.bit.jeap.processcontext.domain.ImmutableDomainEntity;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstance;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="process_instance_process_data")
public class ProcessData
extends ImmutableDomainEntity {
    @Id
    @NotNull
    private UUID id = Generators.timeBasedEpochGenerator().generate();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="process_instance_id")
    private ProcessInstance processInstance;
    @NotNull
    @Column(name="key_")
    private String key;
    @NotNull
    @Column(name="value_")
    private String value;
    private String role;

    public ProcessData(String key, String value) {
        Objects.requireNonNull(key, "Key is mandatory.");
        Objects.requireNonNull(value, "Value is mandatory.");
        this.key = key;
        this.value = value;
        this.role = null;
        this.createdAt = ZonedDateTime.now();
    }

    public ProcessData(String key, String value, String role) {
        this(key, value);
        this.role = role;
    }

    @Override
    public ZonedDateTime getCreatedAt() {
        return super.getCreatedAt();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public String toString() {
        return "ProcessData(id=" + String.valueOf(this.getId()) + ", key=" + this.getKey() + ", value=" + this.getValue() + ", role=" + this.getRole() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessData)) {
            return false;
        }
        ProcessData other = (ProcessData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        return !(this$role == null ? other$role != null : !this$role.equals(other$role));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        return result;
    }

    @Generated
    protected ProcessData() {
    }

    @Generated
    void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }
}

