/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain;

import ch.admin.bit.jeap.processcontext.domain.Language;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TranslateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TranslateService.class);
    private static final String DEFAULT_BUNDLE_LOCATION = "default-messages/messages";
    private static final String BUNDLE_LOCATION = "process/messages/messages";
    public static final String TASK = ".task.";
    public static final String FALLBACK_DEFAULT = "-";
    private final ResourceBundle defaultGerman;
    private final ResourceBundle defaultFrench;
    private final ResourceBundle defaultItalian;
    private final ResourceBundle german;
    private final ResourceBundle french;
    private final ResourceBundle italian;

    public TranslateService() {
        log.info("Loading default translations ResourceBundle from classpath {}", (Object)DEFAULT_BUNDLE_LOCATION);
        this.defaultGerman = ResourceBundle.getBundle(DEFAULT_BUNDLE_LOCATION);
        this.defaultFrench = ResourceBundle.getBundle(DEFAULT_BUNDLE_LOCATION, Locale.FRENCH);
        this.defaultItalian = ResourceBundle.getBundle(DEFAULT_BUNDLE_LOCATION, Locale.ITALIAN);
        log.info("Default ResourceBundles loaded");
        log.info("Loading translations ResourceBundle from classpath {}", (Object)BUNDLE_LOCATION);
        this.german = ResourceBundle.getBundle(BUNDLE_LOCATION);
        this.french = ResourceBundle.getBundle(BUNDLE_LOCATION, Locale.FRENCH);
        this.italian = ResourceBundle.getBundle(BUNDLE_LOCATION, Locale.ITALIAN);
        log.info("ResourceBundles loaded");
    }

    public Map<String, String> translateProcessTemplateName(@NonNull String processTemplateName) {
        if (processTemplateName == null) {
            throw new NullPointerException("processTemplateName is marked non-null but is null");
        }
        return this.retrieveLabels(processTemplateName + ".label");
    }

    public Map<String, String> translateProcessTemplateName(@NonNull String processTemplateName, @NonNull String processTemplateLabel) {
        if (processTemplateName == null) {
            throw new NullPointerException("processTemplateName is marked non-null but is null");
        }
        if (processTemplateLabel == null) {
            throw new NullPointerException("processTemplateLabel is marked non-null but is null");
        }
        return this.retrieveLabelsWithDefault(processTemplateName + ".label", processTemplateLabel);
    }

    public Map<String, String> translateMilestoneName(@NonNull String processTemplate, @NonNull String milestoneName) {
        if (processTemplate == null) {
            throw new NullPointerException("processTemplate is marked non-null but is null");
        }
        if (milestoneName == null) {
            throw new NullPointerException("milestoneName is marked non-null but is null");
        }
        return this.retrieveLabels(processTemplate + ".milestone." + milestoneName);
    }

    public Map<String, String> translateTaskTypeName(@NonNull String processTemplate, @NonNull String taskTypeName) {
        if (processTemplate == null) {
            throw new NullPointerException("processTemplate is marked non-null but is null");
        }
        if (taskTypeName == null) {
            throw new NullPointerException("taskTypeName is marked non-null but is null");
        }
        return this.retrieveLabels(processTemplate + TASK + taskTypeName);
    }

    public Map<String, String> translateTaskDataKey(@NonNull String processTemplate, @NonNull String taskTypeName, @NonNull String taskDataKey) {
        if (processTemplate == null) {
            throw new NullPointerException("processTemplate is marked non-null but is null");
        }
        if (taskTypeName == null) {
            throw new NullPointerException("taskTypeName is marked non-null but is null");
        }
        if (taskDataKey == null) {
            throw new NullPointerException("taskDataKey is marked non-null but is null");
        }
        return this.retrieveLabels(processTemplate + TASK + taskTypeName + ".data." + taskDataKey);
    }

    public Map<String, String> translateProcessRelationOriginRole(@NonNull String processTemplate, @NonNull String relationName) {
        if (processTemplate == null) {
            throw new NullPointerException("processTemplate is marked non-null but is null");
        }
        if (relationName == null) {
            throw new NullPointerException("relationName is marked non-null but is null");
        }
        return this.retrieveLabels(processTemplate + "." + relationName + ".originRole");
    }

    public Map<String, String> translateProcessRelationTargetRole(@NonNull String processTemplate, @NonNull String relationName) {
        if (processTemplate == null) {
            throw new NullPointerException("processTemplate is marked non-null but is null");
        }
        if (relationName == null) {
            throw new NullPointerException("relationName is marked non-null but is null");
        }
        return this.retrieveLabels(processTemplate + "." + relationName + ".targetRole");
    }

    public Map<String, String> translateProcessCompletionName(@NonNull String processTemplate, String processCompletionName) {
        if (processTemplate == null) {
            throw new NullPointerException("processTemplate is marked non-null but is null");
        }
        if (processCompletionName == null) {
            return TranslateService.noTranslation(FALLBACK_DEFAULT);
        }
        if (processCompletionName.equals("legacyProcessCompletionCondition") || processCompletionName.equals("allTasksInFinalStateProcessCompletionCondition")) {
            return this.retrieveLabels("completion." + processCompletionName);
        }
        String key = processTemplate + ".completion." + processCompletionName;
        try {
            return this.retrieveLabels(key);
        }
        catch (IllegalArgumentException e) {
            log.warn("No translation found for key '{}'. Using the name as label...", (Object)key);
            return TranslateService.noTranslation(processCompletionName);
        }
    }

    public Map<String, String> translateProcessCompletionNameFromSnapshot(@NonNull String processTemplate, String processCompletionName, String completionLegacyLabel) {
        if (processTemplate == null) {
            throw new NullPointerException("processTemplate is marked non-null but is null");
        }
        if (processCompletionName != null) {
            if (processCompletionName.equals("legacyProcessCompletionCondition") || processCompletionName.equals("allTasksInFinalStateProcessCompletionCondition")) {
                return this.retrieveLabels("completion." + processCompletionName);
            }
            String key = processTemplate + ".completion." + processCompletionName;
            try {
                return this.retrieveLabels(key);
            }
            catch (IllegalArgumentException e) {
                log.warn("No translation found for key '{}'", (Object)key);
            }
        }
        if (completionLegacyLabel != null) {
            log.warn("Using the legacy label as label...");
            return TranslateService.noTranslation(completionLegacyLabel);
        }
        if (processCompletionName != null) {
            log.warn("Using the processCompletionName as label...");
            return TranslateService.noTranslation(processCompletionName);
        }
        return TranslateService.noTranslation(FALLBACK_DEFAULT);
    }

    public Map<String, String> translateUserDataKey(@NonNull String userDataKey) {
        if (userDataKey == null) {
            throw new NullPointerException("userDataKey is marked non-null but is null");
        }
        return this.retrieveLabelsWithDefault("userData." + userDataKey, userDataKey);
    }

    public Map<String, String> translateUserDataKey(@NonNull String userDataKey, String userDataLabel) {
        if (userDataKey == null) {
            throw new NullPointerException("userDataKey is marked non-null but is null");
        }
        return this.retrieveLabelsWithDefault("userData." + userDataKey, StringUtils.hasText((String)userDataLabel) ? userDataLabel : userDataKey);
    }

    public Map<String, String> translateTaskDataKey(@NonNull String processTemplate, @NonNull String taskTypeName, @NonNull String taskDataKey, String taskDataLabel) {
        if (processTemplate == null) {
            throw new NullPointerException("processTemplate is marked non-null but is null");
        }
        if (taskTypeName == null) {
            throw new NullPointerException("taskTypeName is marked non-null but is null");
        }
        if (taskDataKey == null) {
            throw new NullPointerException("taskDataKey is marked non-null but is null");
        }
        return this.retrieveLabelsWithDefault(processTemplate + TASK + taskTypeName + ".data." + taskDataKey, StringUtils.hasText((String)taskDataLabel) ? taskDataLabel : taskDataKey);
    }

    public Map<String, String> translateTaskTypeName(@NonNull String processTemplate, @NonNull String taskTypeName, String taskTypeLabel) {
        if (processTemplate == null) {
            throw new NullPointerException("processTemplate is marked non-null but is null");
        }
        if (taskTypeName == null) {
            throw new NullPointerException("taskTypeName is marked non-null but is null");
        }
        return this.retrieveLabelsWithDefault(processTemplate + TASK + taskTypeName, StringUtils.hasText((String)taskTypeLabel) ? taskTypeLabel : taskTypeName);
    }

    public static Map<String, String> noTranslation(@NonNull String value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        HashMap<String, String> translations = new HashMap<String, String>();
        Arrays.asList(Language.values()).forEach(language -> translations.put(language.languageId(), value));
        return translations;
    }

    private Map<String, String> retrieveLabelsWithDefault(@NonNull String key, @NonNull String defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        try {
            return this.retrieveLabels(key);
        }
        catch (IllegalArgumentException e) {
            log.warn("No translation found for key '{}'. Using the defaultValue as translation...", (Object)key);
            return TranslateService.noTranslation(defaultValue);
        }
    }

    private Map<String, String> retrieveLabels(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put(Language.DE.languageId(), this.getString(this.defaultGerman, this.german, key));
        labels.put(Language.FR.languageId(), this.getString(this.defaultFrench, this.french, key));
        labels.put(Language.IT.languageId(), this.getString(this.defaultItalian, this.italian, key));
        return labels;
    }

    private String getString(@NonNull ResourceBundle defaultResourceBundle, @NonNull ResourceBundle resourceBundle, @NonNull String key) {
        if (defaultResourceBundle == null) {
            throw new NullPointerException("defaultResourceBundle is marked non-null but is null");
        }
        if (resourceBundle == null) {
            throw new NullPointerException("resourceBundle is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (resourceBundle.containsKey(key)) {
            return resourceBundle.getString(key);
        }
        if (defaultResourceBundle.containsKey(key)) {
            return defaultResourceBundle.getString(key);
        }
        throw new IllegalArgumentException("No translation found in ResourceBundles for key: '" + key + "'");
    }
}

