/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processinstance;

import ch.admin.bit.jeap.processcontext.domain.MutableDomainEntity;
import ch.admin.bit.jeap.processcontext.domain.message.Message;
import ch.admin.bit.jeap.processcontext.domain.message.MessageData;
import ch.admin.bit.jeap.processcontext.domain.message.OriginTaskId;
import ch.admin.bit.jeap.processcontext.domain.processinstance.MessageReference;
import ch.admin.bit.jeap.processcontext.domain.processinstance.MessageReferenceMessageDTO;
import ch.admin.bit.jeap.processcontext.domain.processinstance.MessageReferenceMessageDataDTO;
import ch.admin.bit.jeap.processcontext.domain.processinstance.Milestone;
import ch.admin.bit.jeap.processcontext.domain.processinstance.NotFoundException;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessCompletion;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessCompletionConclusion;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessContextFactory;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessData;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessDataWrapper;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessRelation;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessState;
import ch.admin.bit.jeap.processcontext.domain.processinstance.Relation;
import ch.admin.bit.jeap.processcontext.domain.processinstance.RelationFactory;
import ch.admin.bit.jeap.processcontext.domain.processinstance.TaskInstance;
import ch.admin.bit.jeap.processcontext.domain.processinstance.TaskPlanningException;
import ch.admin.bit.jeap.processcontext.domain.processinstance.TaskState;
import ch.admin.bit.jeap.processcontext.domain.processinstance.TaskUtils;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessDataTemplate;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessRelationPattern;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessTemplate;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.TaskType;
import ch.admin.bit.jeap.processcontext.plugin.api.condition.ProcessCompletionConditionResult;
import ch.admin.bit.jeap.processcontext.plugin.api.condition.ProcessSnapshotConditionResult;
import ch.admin.bit.jeap.processcontext.plugin.api.context.ProcessContext;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Converter;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

@Entity
public class ProcessInstance
extends MutableDomainEntity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessInstance.class);
    @Id
    @NotNull
    private UUID id = Generators.timeBasedEpochGenerator().generate();
    @Column(unique=true)
    @NotNull
    private String originProcessId;
    @NotNull
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="processInstance")
    private Set<ProcessData> processData;
    @NotNull
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="processInstance")
    private Set<Relation> relations;
    @NotNull
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="processInstance")
    private Set<ProcessRelation> processRelations;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private ProcessState state;
    @Embedded
    ProcessCompletion processCompletion;
    @NotNull
    @Column(name="template_name")
    private String processTemplateName;
    @Column(name="template_hash")
    private String processTemplateHash;
    @Transient
    private ProcessTemplate processTemplate;
    private ZonedDateTime lastCorrelationAt;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="processInstance")
    private List<TaskInstance> tasks = new ArrayList<TaskInstance>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="processInstance")
    private List<MessageReference> messageReferences = new ArrayList<MessageReference>();
    @Transient
    private List<MessageReferenceMessageDTO> messageReferenceMessageDTOS = new ArrayList<MessageReferenceMessageDTO>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="processInstance")
    private List<Milestone> milestones = new ArrayList<Milestone>();
    private int latestSnapshotVersion = 0;
    @Convert(converter=SnapshotNameSetConverter.class)
    private LinkedHashSet<String> snapshotNames = new LinkedHashSet();

    private ProcessInstance(String originProcessId, ProcessTemplate processTemplate, Set<ProcessData> processData) {
        Objects.requireNonNull(originProcessId, "Origin process ID is mandatory");
        Objects.requireNonNull(processTemplate, "Process template is mandatory");
        this.originProcessId = originProcessId;
        this.processData = new HashSet<ProcessData>();
        this.addProcessData(processData);
        this.relations = new HashSet<Relation>();
        this.processRelations = new HashSet<ProcessRelation>();
        this.processTemplate = processTemplate;
        this.processTemplateName = processTemplate.getName();
        this.processTemplateHash = processTemplate.getTemplateHash();
        this.state = ProcessState.STARTED;
    }

    public static ProcessInstance startProcess(String originProcessId, ProcessTemplate processTemplate, Set<ProcessData> processData) {
        ProcessInstance processInstance = new ProcessInstance(originProcessId, processTemplate, processData);
        processInstance.planInitialTasks();
        processInstance.createMilestones();
        return processInstance;
    }

    public int nextSnapshotVersion() {
        ++this.latestSnapshotVersion;
        return this.latestSnapshotVersion;
    }

    public void registerSnapshot(String snapshotName) {
        this.snapshotNames.add(snapshotName);
    }

    private void createMilestones() {
        this.processTemplate.getMilestoneNames().forEach(milestoneName -> this.milestones.add(Milestone.createNew(milestoneName, this.processTemplate.getMilestoneConditionByMilestoneName((String)milestoneName).orElseThrow(NotFoundException.milestoneNotFound(milestoneName, this.processTemplateName, this.originProcessId)), this)));
    }

    private void planInitialTasks() {
        Set<TaskType> taskTypesWithoutTaskInstance = TaskUtils.taskTypesWithoutTaskInstance(this.tasks, this.processTemplate);
        taskTypesWithoutTaskInstance.stream().filter(TaskType::isPlannedAtProcessStart).map(type -> TaskInstance.createInitialTaskInstance(type, this, ZonedDateTime.now())).forEach(this.tasks::add);
        this.updateProcessState();
    }

    void registerNewTaskInUnknownState(TaskType taskType, ZonedDateTime timestamp) {
        this.tasks.add(TaskInstance.createUnknownTaskInstance(taskType, this, timestamp));
        this.updateProcessState();
    }

    void planDomainEventTask(TaskType taskType, String originTaskId, ZonedDateTime timestamp, UUID messageId) {
        this.tasks.add(TaskInstance.createTaskInstanceWithOriginTaskId(taskType, this, originTaskId, timestamp, messageId));
    }

    void addObservationTask(TaskType taskType, String messageId, ZonedDateTime timestamp, UUID messageUuid) {
        this.tasks.add(TaskInstance.createTaskInstanceWithOriginTaskIdAndState(taskType, this, messageId, TaskState.COMPLETED, timestamp, messageUuid));
    }

    void evaluateCompletedTasks(ZonedDateTime timestamp) {
        for (MessageReferenceMessageDTO messageReference : this.getMessageReferences()) {
            this.evaluateCompletedTasks(messageReference, timestamp);
        }
        this.updateProcessState();
    }

    void evaluateCompletedTasks(MessageReferenceMessageDTO messageReference, ZonedDateTime timestamp) {
        this.getTasks().forEach(task -> task.evaluateIfCompleted(messageReference, timestamp));
    }

    void evaluateReachedMilestones() {
        ProcessContext processContext = ProcessContextFactory.createProcessContext(this);
        this.milestones.forEach(milestone -> milestone.evaluateIfReached(processContext));
    }

    Set<String> evaluateSnapshotConditions() {
        if (this.getProcessTemplate() == null || this.getProcessTemplate().getProcessSnapshotConditions().isEmpty()) {
            return Collections.emptySet();
        }
        ProcessContext processContext = ProcessContextFactory.createProcessContext(this);
        return this.getProcessTemplate().getProcessSnapshotConditions().stream().map(snapshotCondition -> snapshotCondition.triggerSnapshot(processContext)).filter(ProcessSnapshotConditionResult::isSnapShotTriggered).map(ProcessSnapshotConditionResult::getSnapshotName).filter(snapshotName -> !this.snapshotNames.contains(snapshotName)).collect(Collectors.toSet());
    }

    public List<TaskInstance> getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    public List<TaskInstance> getOpenTasks() {
        return this.getTasks().stream().filter(t -> !t.getState().isFinalState()).toList();
    }

    public List<Milestone> getMilestones() {
        return Collections.unmodifiableList(this.milestones);
    }

    public Set<String> getReachedMilestones() {
        return this.milestones.stream().filter(Milestone::isReached).map(Milestone::getName).collect(Collectors.toSet());
    }

    public List<MessageReferenceMessageDTO> getMessageReferences() {
        return Collections.unmodifiableList(this.messageReferenceMessageDTOS);
    }

    public MessageReferenceMessageDTO addMessage(Message message) {
        MessageReference messageReference = MessageReference.from(message);
        messageReference.setOwner(this);
        this.copyMessageDataToProcessData(message);
        this.messageReferences.add(messageReference);
        MessageReferenceMessageDTO messageReferenceMessageDTO = this.toMessageReferenceMessageDTO(messageReference.getId(), message);
        this.messageReferenceMessageDTOS.add(messageReferenceMessageDTO);
        return messageReferenceMessageDTO;
    }

    private MessageReferenceMessageDTO toMessageReferenceMessageDTO(UUID messageReferenceId, Message message) {
        return MessageReferenceMessageDTO.builder().messageReferenceId(messageReferenceId).messageId(message.getId()).messageName(message.getMessageName()).messageReceivedAt(message.getReceivedAt()).messageData(ProcessInstance.toDto(message.getMessageData(this.processTemplateName))).relatedOriginTaskIds(ProcessInstance.toRelatedOriginTaskIds(message.getOriginTaskIds(this.processTemplateName))).build();
    }

    private static Set<MessageReferenceMessageDataDTO> toDto(Set<MessageData> messageData) {
        return messageData.stream().map(MessageReferenceMessageDataDTO::from).collect(Collectors.toSet());
    }

    private static Set<String> toRelatedOriginTaskIds(Set<OriginTaskId> originTaskIds) {
        return originTaskIds.stream().map(OriginTaskId::getOriginTaskId).collect(Collectors.toSet());
    }

    public Optional<ch.admin.bit.jeap.processcontext.plugin.api.context.ProcessCompletion> getProcessCompletion() {
        ProcessCompletion reportedCompletion = this.processCompletion;
        if (this.state == ProcessState.COMPLETED && reportedCompletion == null) {
            reportedCompletion = new ProcessCompletion(ProcessCompletionConclusion.SUCCEEDED, "All tasks completed.", this.getModifiedAt());
        }
        return Optional.ofNullable(reportedCompletion).map(completion -> ch.admin.bit.jeap.processcontext.plugin.api.context.ProcessCompletion.builder().conclusion(ch.admin.bit.jeap.processcontext.plugin.api.context.ProcessCompletionConclusion.valueOf((String)completion.getConclusion().name())).name(completion.getName()).completedAt(completion.getCompletedAt()).build());
    }

    public void setProcessTemplate(ProcessTemplate processTemplate) {
        if (this.processTemplate != null) {
            throw new IllegalStateException("Cannot set process template - already set for process " + this.originProcessId);
        }
        this.processTemplate = processTemplate;
        this.tasks.forEach(task -> task.setTaskTypeFromTemplate(processTemplate));
        this.milestones.forEach(milestone -> milestone.setMilestoneConditionFromTemplate(processTemplate));
    }

    private void updateProcessState() {
        if (this.state == ProcessState.COMPLETED) {
            return;
        }
        ProcessContext processContext = ProcessContextFactory.createProcessContext(this);
        this.processTemplate.getProcessCompletionConditions().stream().map(condition -> condition.isProcessCompleted(processContext)).filter(ProcessCompletionConditionResult::isCompleted).findFirst().ifPresent(result -> {
            this.state = ProcessState.COMPLETED;
            this.processCompletion = new ProcessCompletion(ProcessCompletionConclusion.valueOf(((ch.admin.bit.jeap.processcontext.plugin.api.context.ProcessCompletionConclusion)result.getConclusion().get()).name()), result.getName().orElse(null), ZonedDateTime.now());
        });
    }

    @Override
    public ZonedDateTime getCreatedAt() {
        return super.getCreatedAt();
    }

    @Override
    public ZonedDateTime getModifiedAt() {
        return super.getModifiedAt();
    }

    public Set<ProcessData> getProcessData() {
        return Collections.unmodifiableSet(this.processData);
    }

    private void copyMessageDataToProcessData(Message message) {
        String messageName = message.getMessageName();
        Set<MessageData> messageData = message.getMessageData(this.processTemplateName);
        List<ProcessDataTemplate> processDataTemplates = this.processTemplate.getProcessDataTemplatesBySourceMessageName(messageName);
        processDataTemplates.forEach(template -> this.applyProcessDataTemplate(messageName, messageData, (ProcessDataTemplate)template));
    }

    private void applyProcessDataTemplate(String messageName, Set<MessageData> messageDataSet, ProcessDataTemplate processDataTemplate) {
        String sourceKey = processDataTemplate.getSourceMessageDataKey();
        String targetKey = processDataTemplate.getKey();
        messageDataSet.forEach(messageData -> {
            if (sourceKey.equals(messageData.getKey())) {
                this.addProcessData(messageName, targetKey, (MessageData)messageData);
            }
        });
    }

    private void addProcessData(String messageName, String targetKey, MessageData messageData) {
        ProcessData processDataItem = new ProcessData(targetKey, messageData.getValue(), messageData.getRole());
        if (this.processData.add(processDataItem)) {
            processDataItem.setProcessInstance(this);
            log.debug("Added process data to process instance {}: messageName: {}, key: {}, value: {}, role: {}", new Object[]{this.id, messageName, targetKey, messageData.getValue(), messageData.getRole()});
        }
    }

    private void addProcessData(Set<ProcessData> processData) {
        if (processData != null) {
            processData.forEach(item -> item.setProcessInstance(this));
            this.processData.addAll(processData);
        }
    }

    public Set<Relation> getRelations() {
        return Collections.unmodifiableSet(this.relations);
    }

    void evaluateRelations() {
        if (this.processTemplate.getRelationPatterns().isEmpty()) {
            return;
        }
        ProcessDataWrapper processDataWrapper = ProcessDataWrapper.of(this.processData);
        String systemId = this.processTemplate.getRelationSystemId();
        this.processTemplate.getRelationPatterns().stream().flatMap(pattern -> RelationFactory.createMatchingRelations(systemId, pattern, processDataWrapper).stream()).forEach(this::addRelation);
    }

    private void addRelation(Relation relation) {
        if (this.relations.add(relation)) {
            relation.setProcessInstance(this);
            relation.onPrePersist();
            log.debug("Added relation to process instance {}: {}", (Object)this.id, (Object)relation);
        }
    }

    public Set<ProcessRelation> getProcessRelations() {
        return Collections.unmodifiableSet(this.processRelations);
    }

    private void addProcessRelation(ProcessRelation processRelation) {
        if (this.processRelations.add(processRelation)) {
            processRelation.setProcessInstance(this);
            processRelation.onPrePersist();
            log.debug("Added process relation to process instance {}: {}", (Object)this.id, (Object)processRelation);
        }
    }

    void evaluateProcessRelations(Message message) {
        if (this.processTemplate.getProcessRelationPatterns().isEmpty()) {
            return;
        }
        List<ProcessRelationPattern> patterns = this.processTemplate.getProcessRelationPatterns();
        patterns.forEach(processRelationPattern -> {
            String messageName = processRelationPattern.getSource().getMessageName();
            String messageKey = processRelationPattern.getSource().getMessageDataKey();
            if (messageName.equals(message.getMessageName())) {
                Set<MessageData> messageDataSet = message.getMessageData(this.processTemplateName);
                messageDataSet.forEach(messageData -> {
                    if (messageKey.equals(messageData.getKey())) {
                        String msgDataValue = messageData.getValue();
                        ProcessRelation processRelation = ProcessRelation.createMatchingProcessRelation(processRelationPattern, msgDataValue);
                        this.addProcessRelation(processRelation);
                    }
                });
            }
        });
    }

    public Optional<ZonedDateTime> getLastMessageDateTime() {
        MessageReferenceMessageDTO lastMessage = this.getMessageReferences().stream().max(Comparator.comparing(MessageReferenceMessageDTO::getMessageReceivedAt)).orElse(null);
        if (lastMessage != null) {
            return Optional.of(lastMessage.getMessageReceivedAt());
        }
        return Optional.empty();
    }

    void correlatedAt(ZonedDateTime lastCorrelationAt) {
        this.lastCorrelationAt = lastCorrelationAt;
    }

    public void applyTemplateMigrationIfChanged() {
        if (this.isTemplateChanged()) {
            log.info("Applying template migrations to process {}", (Object)this.getOriginProcessId());
            this.deleteTaskInstancesForDeletedTaskTypes();
            this.planTaskInstancesForNewTaskTypes();
            this.deleteMilestonesForDeletedMilestonesFromTemplate();
            this.createNewMilestonesForNewMilestonesFromTemplate();
            this.updateTemplateHash();
            this.evaluateCompletedTasksAndReachedMilestones(ZonedDateTime.now());
        }
    }

    void evaluateCompletedTasksAndReachedMilestones(ZonedDateTime timestamp) {
        this.evaluateCompletedTasks(timestamp);
        this.evaluateReachedMilestones();
    }

    private boolean isTemplateChanged() {
        return this.processTemplateHash != null && !this.processTemplate.getTemplateHash().equals(this.processTemplateHash);
    }

    private void updateTemplateHash() {
        this.processTemplateHash = this.processTemplate.getTemplateHash();
    }

    private void deleteTaskInstancesForDeletedTaskTypes() {
        List<TaskInstance> openTasks = this.getOpenTasks();
        log.debug("Migration - Found {} open tasks in processInstance '{}'", (Object)openTasks.size(), (Object)this.getOriginProcessId());
        Set<String> allTaskNames = this.getProcessTemplate().getTaskNames();
        List<TaskInstance> taskToDelete = openTasks.stream().filter(openTask -> !allTaskNames.contains(openTask.getTaskTypeName())).toList();
        log.debug("Migration - Found {} open tasks to set as deleted", (Object)taskToDelete.size());
        for (TaskInstance task : taskToDelete) {
            log.info("Migration - Set State DELETED for TaskInstance '{}'", (Object)task.getTaskTypeName());
            task.delete();
        }
    }

    private void planTaskInstancesForNewTaskTypes() {
        Set taskInstanceNames = this.getTasks().stream().map(TaskInstance::getTaskTypeName).collect(Collectors.toUnmodifiableSet());
        HashSet<String> allTaskNames = new HashSet<String>(this.getProcessTemplate().getTaskNames());
        log.debug("Migration - Found {} task types in process template '{}'", (Object)allTaskNames.size(), (Object)this.getProcessTemplate().getName());
        allTaskNames.removeAll(taskInstanceNames);
        log.debug("Migration - Found {} new task types", (Object)allTaskNames.size());
        for (String taskName : allTaskNames) {
            TaskType taskType = this.processTemplate.getTaskTypeByName(taskName).orElseThrow(TaskPlanningException.invalidTaskType(taskName, this.originProcessId));
            if (taskType.isPlannedAtProcessStart()) {
                log.info("Migration - Plan new instance of task '{}'", (Object)taskName);
                this.registerNewTaskInUnknownState(taskType, ZonedDateTime.now());
                continue;
            }
            log.info("Migration - Task '{}' does not need upfront planning.", (Object)taskName);
        }
    }

    private void deleteMilestonesForDeletedMilestonesFromTemplate() {
        List<Milestone> openMilestones = this.getMilestones().stream().filter(t -> !t.isReached()).toList();
        log.debug("Migration - Found {} open milestones in processInstance '{}'", (Object)openMilestones.size(), (Object)this.getOriginProcessId());
        Set<String> allMilestones = this.getProcessTemplate().getMilestoneNames();
        List<Milestone> milestonesToDelete = openMilestones.stream().filter(openMilestone -> !allMilestones.contains(openMilestone.getName())).toList();
        log.debug("Migration - Found {} open milestones to set as deleted", (Object)milestonesToDelete.size());
        for (Milestone milestone : milestonesToDelete) {
            log.info("Migration - Set State DELETED for Milestone '{}'", (Object)milestone.getName());
            milestone.delete();
        }
    }

    private void createNewMilestonesForNewMilestonesFromTemplate() {
        Set milestonesFromInstance = this.getMilestones().stream().map(Milestone::getName).collect(Collectors.toUnmodifiableSet());
        Set<String> milestoneNames = this.getProcessTemplate().getMilestoneNames();
        log.debug("Migration - Found {} milestones in process template '{}'", (Object)milestonesFromInstance.size(), (Object)this.getProcessTemplate().getName());
        Set newMilestoneNames = milestoneNames.stream().filter(milestone -> !milestonesFromInstance.contains(milestone)).collect(Collectors.toUnmodifiableSet());
        log.debug("Migration - Found {} new milestones", (Object)milestoneNames.size());
        for (String newMilestone : newMilestoneNames) {
            log.info("Migration - Create new milestone '{}'", (Object)newMilestone);
            this.milestones.add(Milestone.createNewUnknown(newMilestone, this.getProcessTemplate().getMilestoneConditionByMilestoneName(newMilestone).orElseThrow(NotFoundException.milestoneNotFound(newMilestone, this.processTemplate.getName(), this.getOriginProcessId())), this));
        }
    }

    @Generated
    protected ProcessInstance() {
    }

    @Generated
    public String toString() {
        return "ProcessInstance(id=" + String.valueOf(this.getId()) + ", originProcessId=" + this.getOriginProcessId() + ", processData=" + String.valueOf(this.getProcessData()) + ", relations=" + String.valueOf(this.getRelations()) + ", processRelations=" + String.valueOf(this.getProcessRelations()) + ", state=" + String.valueOf((Object)this.getState()) + ", processCompletion=" + String.valueOf(this.getProcessCompletion()) + ", processTemplateName=" + this.getProcessTemplateName() + ", processTemplateHash=" + this.getProcessTemplateHash() + ", processTemplate=" + String.valueOf(this.getProcessTemplate()) + ", lastCorrelationAt=" + String.valueOf(this.getLastCorrelationAt()) + ", tasks=" + String.valueOf(this.getTasks()) + ", messageReferences=" + String.valueOf(this.getMessageReferences()) + ", messageReferenceMessageDTOS=" + String.valueOf(this.messageReferenceMessageDTOS) + ", milestones=" + String.valueOf(this.getMilestones()) + ", latestSnapshotVersion=" + this.getLatestSnapshotVersion() + ", snapshotNames=" + String.valueOf(this.getSnapshotNames()) + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getOriginProcessId() {
        return this.originProcessId;
    }

    @Generated
    public ProcessState getState() {
        return this.state;
    }

    @Generated
    public String getProcessTemplateName() {
        return this.processTemplateName;
    }

    @Generated
    public String getProcessTemplateHash() {
        return this.processTemplateHash;
    }

    @Generated
    public ProcessTemplate getProcessTemplate() {
        return this.processTemplate;
    }

    @Generated
    public ZonedDateTime getLastCorrelationAt() {
        return this.lastCorrelationAt;
    }

    @Generated
    public void setMessageReferenceMessageDTOS(List<MessageReferenceMessageDTO> messageReferenceMessageDTOS) {
        this.messageReferenceMessageDTOS = messageReferenceMessageDTOS;
    }

    @Generated
    public int getLatestSnapshotVersion() {
        return this.latestSnapshotVersion;
    }

    @Generated
    public LinkedHashSet<String> getSnapshotNames() {
        return this.snapshotNames;
    }

    @Converter
    public static class SnapshotNameSetConverter
    implements AttributeConverter<LinkedHashSet<String>, String> {
        private static final String SEPARATOR_CHAR = " ";

        public String convertToDatabaseColumn(LinkedHashSet<String> snapshotNames) {
            return snapshotNames != null ? String.join((CharSequence)SEPARATOR_CHAR, snapshotNames) : "";
        }

        public LinkedHashSet<String> convertToEntityAttribute(String snapshotNamesString) {
            return StringUtils.hasText((String)snapshotNamesString) ? new LinkedHashSet<String>(Arrays.asList(snapshotNamesString.split(SEPARATOR_CHAR))) : new LinkedHashSet();
        }
    }
}

