/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processinstance;

import ch.admin.bit.jeap.processcontext.domain.ImmutableDomainEntity;
import ch.admin.bit.jeap.processcontext.domain.message.Message;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstance;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="event_reference")
public class MessageReference
extends ImmutableDomainEntity {
    @Id
    @NotNull
    private UUID id = Generators.timeBasedEpochGenerator().generate();
    @NotNull
    @Column(name="events_id")
    private UUID messageId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="process_instance_id")
    private ProcessInstance processInstance;

    public static MessageReference from(Message message) {
        return new MessageReference(message);
    }

    private MessageReference(Message message) {
        Objects.requireNonNull(message, "Message must not be null.");
        this.messageId = message.getId();
    }

    void setOwner(ProcessInstance owner) {
        this.processInstance = owner;
    }

    @Generated
    protected MessageReference() {
    }

    @Generated
    public String toString() {
        return "MessageReference(id=" + String.valueOf(this.getId()) + ", messageId=" + String.valueOf(this.getMessageId()) + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public UUID getMessageId() {
        return this.messageId;
    }

    @Generated
    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }
}

