/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processinstance;

import ch.admin.bit.jeap.processcontext.domain.MutableDomainEntity;
import ch.admin.bit.jeap.processcontext.domain.processinstance.MessageReferenceMessageDTO;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstance;
import ch.admin.bit.jeap.processcontext.domain.processinstance.TaskState;
import ch.admin.bit.jeap.processcontext.domain.processinstance.TaskTypeException;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessTemplate;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.TaskCardinality;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.TaskType;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;

@Entity
public class TaskInstance
extends MutableDomainEntity {
    @Id
    @NotNull
    private UUID id = Generators.timeBasedEpochGenerator().generate();
    @NotNull
    @Column(name="task_type")
    private String taskTypeName;
    @Transient
    private Optional<TaskType> taskType = Optional.empty();
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private TaskState state;
    private String originTaskId;
    @ManyToOne
    @JoinColumn(name="process_instance_id")
    private ProcessInstance processInstance;
    private ZonedDateTime plannedAt;
    private UUID plannedBy;
    private UUID completedBy;
    private ZonedDateTime completedAt;

    @Override
    public ZonedDateTime getCreatedAt() {
        return super.getCreatedAt();
    }

    private TaskInstance(TaskType taskType, ProcessInstance owner, TaskState state, String originTaskId, ZonedDateTime timestamp, UUID messageId) {
        this.taskType = Optional.of(taskType);
        this.taskTypeName = taskType.getName();
        this.processInstance = owner;
        this.state = state;
        this.originTaskId = originTaskId;
        if (TaskState.PLANNED.equals((Object)state)) {
            this.plannedAt = timestamp;
            this.plannedBy = messageId;
        } else if (TaskState.COMPLETED.equals((Object)state)) {
            this.plannedAt = timestamp;
            this.plannedBy = messageId;
            this.completedAt = timestamp;
            this.completedBy = messageId;
        }
    }

    static TaskInstance createTaskInstanceWithOriginTaskId(TaskType taskType, ProcessInstance owner, String originTaskId, ZonedDateTime timestamp, UUID messageId) {
        return TaskInstance.createTaskInstanceWithOriginTaskIdAndState(taskType, owner, originTaskId, TaskState.PLANNED, timestamp, messageId);
    }

    static TaskInstance createTaskInstanceWithOriginTaskIdAndState(TaskType taskType, ProcessInstance owner, String originTaskId, TaskState state, ZonedDateTime timestamp, UUID messageId) {
        return new TaskInstance(taskType, owner, state, originTaskId, timestamp, messageId);
    }

    static TaskInstance createInitialTaskInstance(TaskType taskType, ProcessInstance owner, ZonedDateTime timestamp) {
        return new TaskInstance(taskType, owner, TaskState.PLANNED, null, timestamp, null);
    }

    static TaskInstance createUnknownTaskInstance(TaskType taskType, ProcessInstance owner, ZonedDateTime timestamp) {
        return new TaskInstance(taskType, owner, TaskState.UNKNOWN, null, timestamp, null);
    }

    void plan(String originTaskId, ZonedDateTime timestamp) {
        this.originTaskId = originTaskId;
        this.state = TaskState.PLANNED;
        this.plannedAt = timestamp;
    }

    void notRequired() {
        this.state = TaskState.NOT_REQUIRED;
    }

    void complete(ZonedDateTime timestamp) {
        this.state = TaskState.COMPLETED;
        this.completedAt = timestamp;
    }

    void delete() {
        this.state = TaskState.DELETED;
    }

    public TaskType requireTaskType() {
        return this.getTaskType().orElseThrow(() -> TaskTypeException.createTaskTypeDeleted(this.getTaskTypeName()));
    }

    void setTaskTypeFromTemplate(ProcessTemplate processTemplate) {
        if (this.taskType.isPresent()) {
            throw new IllegalStateException("Cannot set task type - already set for task " + this.taskTypeName + " in process " + this.processInstance.getOriginProcessId());
        }
        this.taskType = processTemplate.getTaskTypeByName(this.taskTypeName);
    }

    void evaluateIfCompleted(MessageReferenceMessageDTO messageReference, ZonedDateTime timestamp) {
        if (Set.of(TaskState.PLANNED, TaskState.NOT_PLANNED).contains((Object)this.state) && this.taskType.isPresent() && this.taskType.get().getCompletedByDomainEvent() != null && this.isCompleted(messageReference)) {
            this.state = TaskState.COMPLETED;
            this.completedAt = timestamp;
            this.completedBy = messageReference.getMessageId();
        }
    }

    private boolean isCompleted(MessageReferenceMessageDTO messageReference) {
        if (this.taskType.isPresent() && TaskCardinality.SINGLE_INSTANCE == this.taskType.get().getCardinality()) {
            return messageReference.getMessageName().equals(this.taskType.get().getCompletedByDomainEvent());
        }
        return this.taskType.isPresent() && messageReference.getMessageName().equals(this.taskType.get().getCompletedByDomainEvent()) && messageReference.getRelatedOriginTaskIds().contains(this.originTaskId);
    }

    @Generated
    protected TaskInstance() {
    }

    @Generated
    public String toString() {
        return "TaskInstance(id=" + String.valueOf(this.getId()) + ", taskTypeName=" + this.getTaskTypeName() + ", taskType=" + String.valueOf(this.getTaskType()) + ", state=" + String.valueOf((Object)this.getState()) + ", originTaskId=" + this.getOriginTaskId() + ", plannedAt=" + String.valueOf(this.getPlannedAt()) + ", plannedBy=" + String.valueOf(this.getPlannedBy()) + ", completedBy=" + String.valueOf(this.getCompletedBy()) + ", completedAt=" + String.valueOf(this.getCompletedAt()) + ")";
    }

    @Generated
    UUID getId() {
        return this.id;
    }

    @Generated
    public String getTaskTypeName() {
        return this.taskTypeName;
    }

    @Generated
    public Optional<TaskType> getTaskType() {
        return this.taskType;
    }

    @Generated
    public TaskState getState() {
        return this.state;
    }

    @Generated
    public String getOriginTaskId() {
        return this.originTaskId;
    }

    @Generated
    ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    @Generated
    public ZonedDateTime getPlannedAt() {
        return this.plannedAt;
    }

    @Generated
    public UUID getPlannedBy() {
        return this.plannedBy;
    }

    @Generated
    public UUID getCompletedBy() {
        return this.completedBy;
    }

    @Generated
    public ZonedDateTime getCompletedAt() {
        return this.completedAt;
    }
}

