/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processinstance;

import ch.admin.bit.jeap.processcontext.domain.MutableDomainEntity;
import ch.admin.bit.jeap.processcontext.domain.processinstance.MilestoneState;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstance;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessTemplate;
import ch.admin.bit.jeap.processcontext.plugin.api.condition.MilestoneCondition;
import ch.admin.bit.jeap.processcontext.plugin.api.context.ProcessContext;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.UUID;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class Milestone
extends MutableDomainEntity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Milestone.class);
    @Id
    @NotNull
    private UUID id = Generators.timeBasedEpochGenerator().generate();
    @NotNull
    private String name;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private MilestoneState state;
    private ZonedDateTime reachedAt;
    @Transient
    private MilestoneCondition condition;
    @ManyToOne
    @JoinColumn(name="process_instance_id")
    private ProcessInstance processInstance;

    Milestone(String name, MilestoneCondition milestoneCondition, ProcessInstance owner, MilestoneState milestoneState) {
        this.name = name;
        this.condition = milestoneCondition;
        this.processInstance = owner;
        this.state = milestoneState;
    }

    public static Milestone createNew(String name, MilestoneCondition milestoneCondition, ProcessInstance owner) {
        return new Milestone(name, milestoneCondition, owner, MilestoneState.NOT_REACHED);
    }

    public static Milestone createNewUnknown(String name, MilestoneCondition milestoneCondition, ProcessInstance owner) {
        return new Milestone(name, milestoneCondition, owner, MilestoneState.UNKNOWN);
    }

    public boolean isReached() {
        return MilestoneState.REACHED.equals((Object)this.state);
    }

    void evaluateIfReached(ProcessContext processContext) {
        if (this.isReached()) {
            return;
        }
        if (this.condition != null && this.condition.isMilestoneReached(processContext)) {
            this.state = MilestoneState.REACHED;
        }
        if (this.isReached()) {
            this.reachedAt = ZonedDateTime.now();
            log.info("Milestone {} reached for process {}", (Object)StructuredArguments.keyValue((String)"milestone", (Object)this.name), (Object)StructuredArguments.keyValue((String)"originProcessId", (Object)this.processInstance.getOriginProcessId()));
        }
    }

    void setMilestoneConditionFromTemplate(ProcessTemplate processTemplate) {
        if (this.condition != null) {
            throw new IllegalStateException("Cannot set milestone condition - already set for milestone " + this.name + " in process " + this.processInstance.getOriginProcessId());
        }
        this.condition = processTemplate.getMilestoneConditionByMilestoneName(this.name).orElse(null);
    }

    public void delete() {
        this.state = MilestoneState.DELETED;
    }

    @Generated
    protected Milestone() {
    }

    @Generated
    public String toString() {
        return "Milestone(id=" + String.valueOf(this.id) + ", name=" + this.getName() + ", state=" + String.valueOf((Object)this.getState()) + ", reachedAt=" + String.valueOf(this.getReachedAt()) + ", condition=" + String.valueOf(this.condition) + ")";
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public MilestoneState getState() {
        return this.state;
    }

    @Generated
    public ZonedDateTime getReachedAt() {
        return this.reachedAt;
    }

    @Generated
    ProcessInstance getProcessInstance() {
        return this.processInstance;
    }
}

