/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processtemplate;

import ch.admin.bit.jeap.processcontext.domain.processtemplate.MessageReference;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessDataTemplate;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessRelationPattern;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessTemplateException;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.RelationPattern;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.TaskType;
import ch.admin.bit.jeap.processcontext.plugin.api.condition.AllTasksInFinalStateProcessCompletionCondition;
import ch.admin.bit.jeap.processcontext.plugin.api.condition.MilestoneCondition;
import ch.admin.bit.jeap.processcontext.plugin.api.condition.ProcessCompletionCondition;
import ch.admin.bit.jeap.processcontext.plugin.api.condition.ProcessSnapshotCondition;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class ProcessTemplate {
    private final String name;
    private final String templateHash;
    private final List<TaskType> taskTypes;
    private final List<MessageReference> messageReferences;
    private final Map<String, TaskType> taskTypesByName;
    private final Map<String, MilestoneCondition> milestones;
    private final List<ProcessCompletionCondition> processCompletionConditions;
    private final List<ProcessDataTemplate> processDataTemplates;
    private final Map<String, List<ProcessDataTemplate>> processDataTemplatesBySourceEventName;
    private final String relationSystemId;
    private final List<RelationPattern> relationPatterns;
    private final List<ProcessRelationPattern> processRelationPatterns;
    private final List<ProcessSnapshotCondition> processSnapshotConditions;

    private ProcessTemplate(@NonNull String name, @NonNull String templateHash, @NonNull List<TaskType> taskTypes, List<MessageReference> messageReferences, Map<String, MilestoneCondition> milestones, List<ProcessDataTemplate> processDataTemplates, String relationSystemId, List<RelationPattern> relationPatterns, List<ProcessCompletionCondition> processCompletionConditions, List<ProcessRelationPattern> processRelationPatterns, List<ProcessSnapshotCondition> processSnapshotConditions) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (templateHash == null) {
            throw new NullPointerException("templateHash is marked non-null but is null");
        }
        if (taskTypes == null) {
            throw new NullPointerException("taskTypes is marked non-null but is null");
        }
        this.name = name;
        this.templateHash = templateHash;
        if (taskTypes.isEmpty()) {
            throw ProcessTemplateException.createEmptyProcessTemplate(name);
        }
        this.taskTypes = taskTypes;
        this.taskTypesByName = taskTypes.stream().collect(Collectors.toMap(TaskType::getName, Function.identity()));
        this.milestones = Objects.requireNonNullElseGet(milestones, Collections::emptyMap);
        this.messageReferences = Objects.requireNonNullElseGet(messageReferences, List::of);
        this.processDataTemplates = Objects.requireNonNullElseGet(processDataTemplates, List::of);
        this.processDataTemplatesBySourceEventName = this.processDataTemplates.stream().collect(Collectors.groupingBy(ProcessDataTemplate::getSourceMessageName));
        this.relationSystemId = relationSystemId;
        this.relationPatterns = Objects.requireNonNullElseGet(relationPatterns, List::of);
        this.processCompletionConditions = processCompletionConditions == null || processCompletionConditions.isEmpty() ? List.of(new AllTasksInFinalStateProcessCompletionCondition()) : List.copyOf(processCompletionConditions);
        this.processRelationPatterns = processRelationPatterns;
        this.processSnapshotConditions = processSnapshotConditions != null ? processSnapshotConditions : List.of();
    }

    public List<TaskType> getTaskTypes() {
        return Collections.unmodifiableList(this.taskTypes);
    }

    public List<MessageReference> getMessageReferences() {
        return Collections.unmodifiableList(this.messageReferences);
    }

    public Optional<TaskType> getTaskTypeByName(String taskTypeName) {
        return Optional.ofNullable(this.taskTypesByName.get(taskTypeName));
    }

    public Set<String> getMilestoneNames() {
        return Set.copyOf(this.milestones.keySet());
    }

    public Optional<MilestoneCondition> getMilestoneConditionByMilestoneName(String name) {
        return Optional.ofNullable(this.milestones.get(name));
    }

    public List<ProcessCompletionCondition> getProcessCompletionConditions() {
        return this.processCompletionConditions;
    }

    public List<ProcessDataTemplate> getProcessDataTemplates() {
        return Collections.unmodifiableList(this.processDataTemplates);
    }

    public List<ProcessDataTemplate> getProcessDataTemplatesBySourceMessageName(String eventName) {
        return this.processDataTemplatesBySourceEventName.getOrDefault(eventName, List.of());
    }

    public List<RelationPattern> getRelationPatterns() {
        return Collections.unmodifiableList(this.relationPatterns);
    }

    public Set<MessageReference> getDomainEventReferencesCorrelatedBy(String processDataKey) {
        Set processDataTemplatesWithProcessDataKey = this.getProcessDataTemplates().stream().filter(pdt -> pdt.getKey().equals(processDataKey)).collect(Collectors.toSet());
        HashSet<MessageReference> messageDataKey = new HashSet<MessageReference>();
        for (ProcessDataTemplate processDataTemplate : processDataTemplatesWithProcessDataKey) {
            messageDataKey.addAll(this.getMessageReferences().stream().filter(der -> der.getCorrelatedByProcessData() != null && der.getCorrelatedByProcessData().getProcessDataKey().equals(processDataTemplate.getKey()) && der.getCorrelatedByProcessData().getMessageDataKey().equals(processDataTemplate.getSourceMessageDataKey())).collect(Collectors.toSet()));
        }
        return messageDataKey;
    }

    public Set<String> getTaskNames() {
        return this.getTaskTypes().stream().map(TaskType::getName).collect(Collectors.toUnmodifiableSet());
    }

    public List<ProcessRelationPattern> getProcessRelationPatterns() {
        return Collections.unmodifiableList(this.processRelationPatterns);
    }

    public List<ProcessSnapshotCondition> getProcessSnapshotConditions() {
        return Collections.unmodifiableList(this.processSnapshotConditions);
    }

    @Generated
    public static ProcessTemplateBuilder builder() {
        return new ProcessTemplateBuilder();
    }

    @Generated
    public String toString() {
        return "ProcessTemplate(name=" + this.getName() + ", templateHash=" + this.getTemplateHash() + ")";
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getTemplateHash() {
        return this.templateHash;
    }

    @Generated
    public String getRelationSystemId() {
        return this.relationSystemId;
    }

    @Generated
    public static class ProcessTemplateBuilder {
        @Generated
        private String name;
        @Generated
        private String templateHash;
        @Generated
        private List<TaskType> taskTypes;
        @Generated
        private List<MessageReference> messageReferences;
        @Generated
        private Map<String, MilestoneCondition> milestones;
        @Generated
        private List<ProcessDataTemplate> processDataTemplates;
        @Generated
        private String relationSystemId;
        @Generated
        private List<RelationPattern> relationPatterns;
        @Generated
        private List<ProcessCompletionCondition> processCompletionConditions;
        @Generated
        private List<ProcessRelationPattern> processRelationPatterns;
        @Generated
        private List<ProcessSnapshotCondition> processSnapshotConditions;

        @Generated
        ProcessTemplateBuilder() {
        }

        @Generated
        public ProcessTemplateBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public ProcessTemplateBuilder templateHash(@NonNull String templateHash) {
            if (templateHash == null) {
                throw new NullPointerException("templateHash is marked non-null but is null");
            }
            this.templateHash = templateHash;
            return this;
        }

        @Generated
        public ProcessTemplateBuilder taskTypes(@NonNull List<TaskType> taskTypes) {
            if (taskTypes == null) {
                throw new NullPointerException("taskTypes is marked non-null but is null");
            }
            this.taskTypes = taskTypes;
            return this;
        }

        @Generated
        public ProcessTemplateBuilder messageReferences(List<MessageReference> messageReferences) {
            this.messageReferences = messageReferences;
            return this;
        }

        @Generated
        public ProcessTemplateBuilder milestones(Map<String, MilestoneCondition> milestones) {
            this.milestones = milestones;
            return this;
        }

        @Generated
        public ProcessTemplateBuilder processDataTemplates(List<ProcessDataTemplate> processDataTemplates) {
            this.processDataTemplates = processDataTemplates;
            return this;
        }

        @Generated
        public ProcessTemplateBuilder relationSystemId(String relationSystemId) {
            this.relationSystemId = relationSystemId;
            return this;
        }

        @Generated
        public ProcessTemplateBuilder relationPatterns(List<RelationPattern> relationPatterns) {
            this.relationPatterns = relationPatterns;
            return this;
        }

        @Generated
        public ProcessTemplateBuilder processCompletionConditions(List<ProcessCompletionCondition> processCompletionConditions) {
            this.processCompletionConditions = processCompletionConditions;
            return this;
        }

        @Generated
        public ProcessTemplateBuilder processRelationPatterns(List<ProcessRelationPattern> processRelationPatterns) {
            this.processRelationPatterns = processRelationPatterns;
            return this;
        }

        @Generated
        public ProcessTemplateBuilder processSnapshotConditions(List<ProcessSnapshotCondition> processSnapshotConditions) {
            this.processSnapshotConditions = processSnapshotConditions;
            return this;
        }

        @Generated
        public ProcessTemplate build() {
            return new ProcessTemplate(this.name, this.templateHash, this.taskTypes, this.messageReferences, this.milestones, this.processDataTemplates, this.relationSystemId, this.relationPatterns, this.processCompletionConditions, this.processRelationPatterns, this.processSnapshotConditions);
        }

        @Generated
        public String toString() {
            return "ProcessTemplate.ProcessTemplateBuilder(name=" + this.name + ", templateHash=" + this.templateHash + ", taskTypes=" + String.valueOf(this.taskTypes) + ", messageReferences=" + String.valueOf(this.messageReferences) + ", milestones=" + String.valueOf(this.milestones) + ", processDataTemplates=" + String.valueOf(this.processDataTemplates) + ", relationSystemId=" + this.relationSystemId + ", relationPatterns=" + String.valueOf(this.relationPatterns) + ", processCompletionConditions=" + String.valueOf(this.processCompletionConditions) + ", processRelationPatterns=" + String.valueOf(this.processRelationPatterns) + ", processSnapshotConditions=" + String.valueOf(this.processSnapshotConditions) + ")";
        }
    }
}

