/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processupdate;

import ch.admin.bit.jeap.processcontext.domain.MutableDomainEntity;
import ch.admin.bit.jeap.processcontext.domain.processupdate.ProcessUpdateType;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class ProcessUpdate
extends MutableDomainEntity {
    @Id
    @NotNull
    private UUID id;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private ProcessUpdateType processUpdateType;
    private boolean handled;
    private boolean failed;
    @NotNull
    private String originProcessId;
    private String params;
    @Column(name="event_reference")
    private UUID messageReference;
    private String name;
    @NotNull
    @Column(name="event_name")
    private String messageName;
    @NotNull
    private String idempotenceId;

    public Optional<UUID> getMessageReference() {
        return Optional.ofNullable(this.messageReference);
    }

    private static ProcessUpdate createMessageReceived(@NonNull String originProcessId, @NonNull UUID messageReference, @NonNull String messageName, @NonNull String idempotenceId) {
        if (originProcessId == null) {
            throw new NullPointerException("originProcessId is marked non-null but is null");
        }
        if (messageReference == null) {
            throw new NullPointerException("messageReference is marked non-null but is null");
        }
        if (messageName == null) {
            throw new NullPointerException("messageName is marked non-null but is null");
        }
        if (idempotenceId == null) {
            throw new NullPointerException("idempotenceId is marked non-null but is null");
        }
        return new ProcessUpdate(Generators.timeBasedEpochGenerator().generate(), ProcessUpdateType.DOMAIN_EVENT, false, false, originProcessId, null, messageReference, null, messageName, idempotenceId);
    }

    private static ProcessUpdate createCreateProcessReceived(@NonNull String originProcessId, @NonNull String template, @NonNull UUID messageReference, @NonNull String messageName, @NonNull String idempotenceId) {
        if (originProcessId == null) {
            throw new NullPointerException("originProcessId is marked non-null but is null");
        }
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (messageReference == null) {
            throw new NullPointerException("messageReference is marked non-null but is null");
        }
        if (messageName == null) {
            throw new NullPointerException("messageName is marked non-null but is null");
        }
        if (idempotenceId == null) {
            throw new NullPointerException("idempotenceId is marked non-null but is null");
        }
        return new ProcessUpdate(Generators.timeBasedEpochGenerator().generate(), ProcessUpdateType.CREATE_PROCESS, false, false, originProcessId, template, messageReference, null, messageName, idempotenceId);
    }

    private static ProcessUpdate createProcessCreated(@NonNull String originProcessId) {
        if (originProcessId == null) {
            throw new NullPointerException("originProcessId is marked non-null but is null");
        }
        return new ProcessUpdate(Generators.timeBasedEpochGenerator().generate(), ProcessUpdateType.PROCESS_CREATED, false, false, originProcessId, null, null, null, "createProcessInstance", originProcessId);
    }

    public void setHandled() {
        this.handled = true;
    }

    @Generated
    public static ProcessUpdateMessageReceivedBuilder messageReceived() {
        return new ProcessUpdateMessageReceivedBuilder();
    }

    @Generated
    public static ProcessUpdateCreateProcessReceivedBuilder createProcessReceived() {
        return new ProcessUpdateCreateProcessReceivedBuilder();
    }

    @Generated
    public static ProcessUpdateProcessCreatedBuilder processCreated() {
        return new ProcessUpdateProcessCreatedBuilder();
    }

    @Generated
    protected ProcessUpdate() {
    }

    @Generated
    private ProcessUpdate(UUID id, ProcessUpdateType processUpdateType, boolean handled, boolean failed, String originProcessId, String params, UUID messageReference, String name, String messageName, String idempotenceId) {
        this.id = id;
        this.processUpdateType = processUpdateType;
        this.handled = handled;
        this.failed = failed;
        this.originProcessId = originProcessId;
        this.params = params;
        this.messageReference = messageReference;
        this.name = name;
        this.messageName = messageName;
        this.idempotenceId = idempotenceId;
    }

    @Generated
    public String toString() {
        return "ProcessUpdate(id=" + String.valueOf(this.getId()) + ", processUpdateType=" + String.valueOf((Object)this.getProcessUpdateType()) + ", handled=" + this.isHandled() + ", failed=" + this.isFailed() + ", originProcessId=" + this.getOriginProcessId() + ", params=" + this.getParams() + ", messageReference=" + String.valueOf(this.getMessageReference()) + ", name=" + this.getName() + ", messageName=" + this.getMessageName() + ", idempotenceId=" + this.getIdempotenceId() + ")";
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public ProcessUpdateType getProcessUpdateType() {
        return this.processUpdateType;
    }

    @Generated
    public boolean isHandled() {
        return this.handled;
    }

    @Generated
    public boolean isFailed() {
        return this.failed;
    }

    @Generated
    public String getOriginProcessId() {
        return this.originProcessId;
    }

    @Generated
    public String getParams() {
        return this.params;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMessageName() {
        return this.messageName;
    }

    @Generated
    public String getIdempotenceId() {
        return this.idempotenceId;
    }

    @Generated
    public static class ProcessUpdateMessageReceivedBuilder {
        @Generated
        private String originProcessId;
        @Generated
        private UUID messageReference;
        @Generated
        private String messageName;
        @Generated
        private String idempotenceId;

        @Generated
        ProcessUpdateMessageReceivedBuilder() {
        }

        @Generated
        public ProcessUpdateMessageReceivedBuilder originProcessId(@NonNull String originProcessId) {
            if (originProcessId == null) {
                throw new NullPointerException("originProcessId is marked non-null but is null");
            }
            this.originProcessId = originProcessId;
            return this;
        }

        @Generated
        public ProcessUpdateMessageReceivedBuilder messageReference(@NonNull UUID messageReference) {
            if (messageReference == null) {
                throw new NullPointerException("messageReference is marked non-null but is null");
            }
            this.messageReference = messageReference;
            return this;
        }

        @Generated
        public ProcessUpdateMessageReceivedBuilder messageName(@NonNull String messageName) {
            if (messageName == null) {
                throw new NullPointerException("messageName is marked non-null but is null");
            }
            this.messageName = messageName;
            return this;
        }

        @Generated
        public ProcessUpdateMessageReceivedBuilder idempotenceId(@NonNull String idempotenceId) {
            if (idempotenceId == null) {
                throw new NullPointerException("idempotenceId is marked non-null but is null");
            }
            this.idempotenceId = idempotenceId;
            return this;
        }

        @Generated
        public ProcessUpdate build() {
            return ProcessUpdate.createMessageReceived(this.originProcessId, this.messageReference, this.messageName, this.idempotenceId);
        }

        @Generated
        public String toString() {
            return "ProcessUpdate.ProcessUpdateMessageReceivedBuilder(originProcessId=" + this.originProcessId + ", messageReference=" + String.valueOf(this.messageReference) + ", messageName=" + this.messageName + ", idempotenceId=" + this.idempotenceId + ")";
        }
    }

    @Generated
    public static class ProcessUpdateCreateProcessReceivedBuilder {
        @Generated
        private String originProcessId;
        @Generated
        private String template;
        @Generated
        private UUID messageReference;
        @Generated
        private String messageName;
        @Generated
        private String idempotenceId;

        @Generated
        ProcessUpdateCreateProcessReceivedBuilder() {
        }

        @Generated
        public ProcessUpdateCreateProcessReceivedBuilder originProcessId(@NonNull String originProcessId) {
            if (originProcessId == null) {
                throw new NullPointerException("originProcessId is marked non-null but is null");
            }
            this.originProcessId = originProcessId;
            return this;
        }

        @Generated
        public ProcessUpdateCreateProcessReceivedBuilder template(@NonNull String template) {
            if (template == null) {
                throw new NullPointerException("template is marked non-null but is null");
            }
            this.template = template;
            return this;
        }

        @Generated
        public ProcessUpdateCreateProcessReceivedBuilder messageReference(@NonNull UUID messageReference) {
            if (messageReference == null) {
                throw new NullPointerException("messageReference is marked non-null but is null");
            }
            this.messageReference = messageReference;
            return this;
        }

        @Generated
        public ProcessUpdateCreateProcessReceivedBuilder messageName(@NonNull String messageName) {
            if (messageName == null) {
                throw new NullPointerException("messageName is marked non-null but is null");
            }
            this.messageName = messageName;
            return this;
        }

        @Generated
        public ProcessUpdateCreateProcessReceivedBuilder idempotenceId(@NonNull String idempotenceId) {
            if (idempotenceId == null) {
                throw new NullPointerException("idempotenceId is marked non-null but is null");
            }
            this.idempotenceId = idempotenceId;
            return this;
        }

        @Generated
        public ProcessUpdate build() {
            return ProcessUpdate.createCreateProcessReceived(this.originProcessId, this.template, this.messageReference, this.messageName, this.idempotenceId);
        }

        @Generated
        public String toString() {
            return "ProcessUpdate.ProcessUpdateCreateProcessReceivedBuilder(originProcessId=" + this.originProcessId + ", template=" + this.template + ", messageReference=" + String.valueOf(this.messageReference) + ", messageName=" + this.messageName + ", idempotenceId=" + this.idempotenceId + ")";
        }
    }

    @Generated
    public static class ProcessUpdateProcessCreatedBuilder {
        @Generated
        private String originProcessId;

        @Generated
        ProcessUpdateProcessCreatedBuilder() {
        }

        @Generated
        public ProcessUpdateProcessCreatedBuilder originProcessId(@NonNull String originProcessId) {
            if (originProcessId == null) {
                throw new NullPointerException("originProcessId is marked non-null but is null");
            }
            this.originProcessId = originProcessId;
            return this;
        }

        @Generated
        public ProcessUpdate build() {
            return ProcessUpdate.createProcessCreated(this.originProcessId);
        }

        @Generated
        public String toString() {
            return "ProcessUpdate.ProcessUpdateProcessCreatedBuilder(originProcessId=" + this.originProcessId + ")";
        }
    }
}

