/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processinstance;

import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstance;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessRelationPattern;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessRelationRoleType;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessRelationRoleVisibility;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
@Table(name="process_instance_process_relations")
public class ProcessRelation {
    @Id
    @NotNull
    private UUID id = Generators.timeBasedEpochGenerator().generate();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="process_instance_id")
    private ProcessInstance processInstance;
    @NotNull
    private String name;
    @Enumerated(value=EnumType.STRING)
    @NonNull
    private ProcessRelationRoleType roleType;
    @NonNull
    private String originRole;
    @NonNull
    private String targetRole;
    @Enumerated(value=EnumType.STRING)
    @NonNull
    private ProcessRelationRoleVisibility visibilityType;
    @NonNull
    private String relatedProcessId;
    private ZonedDateTime createdAt;

    private ProcessRelation(@NonNull String name, @NonNull ProcessRelationRoleType roleType, @NonNull String originRole, @NonNull String targetRole, @NonNull ProcessRelationRoleVisibility visibilityTyp, @NonNull String relatedProcessId) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (roleType == null) {
            throw new NullPointerException("roleType is marked non-null but is null");
        }
        if (originRole == null) {
            throw new NullPointerException("originRole is marked non-null but is null");
        }
        if (targetRole == null) {
            throw new NullPointerException("targetRole is marked non-null but is null");
        }
        if (visibilityTyp == null) {
            throw new NullPointerException("visibilityTyp is marked non-null but is null");
        }
        if (relatedProcessId == null) {
            throw new NullPointerException("relatedProcessId is marked non-null but is null");
        }
        this.name = name;
        this.roleType = roleType;
        this.originRole = originRole;
        this.targetRole = targetRole;
        this.visibilityType = visibilityTyp;
        this.relatedProcessId = relatedProcessId;
    }

    void onPrePersist() {
        this.createdAt = ZonedDateTime.now();
    }

    protected static ProcessRelation createMatchingProcessRelation(ProcessRelationPattern processRelationPattern, String relatedProcessId) {
        return ProcessRelation.builder().name(processRelationPattern.getName()).roleType(processRelationPattern.getRoleType()).originRole(processRelationPattern.getOriginRole()).targetRole(processRelationPattern.getTargetRole()).visibilityTyp(processRelationPattern.getVisibility()).relatedProcessId(relatedProcessId).build();
    }

    @Generated
    static ProcessRelationBuilder builder() {
        return new ProcessRelationBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public ProcessRelationRoleType getRoleType() {
        return this.roleType;
    }

    @NonNull
    @Generated
    public String getOriginRole() {
        return this.originRole;
    }

    @NonNull
    @Generated
    public String getTargetRole() {
        return this.targetRole;
    }

    @NonNull
    @Generated
    public ProcessRelationRoleVisibility getVisibilityType() {
        return this.visibilityType;
    }

    @NonNull
    @Generated
    public String getRelatedProcessId() {
        return this.relatedProcessId;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String toString() {
        return "ProcessRelation(id=" + String.valueOf(this.getId()) + ", name=" + this.getName() + ", roleType=" + String.valueOf((Object)this.getRoleType()) + ", originRole=" + this.getOriginRole() + ", targetRole=" + this.getTargetRole() + ", visibilityType=" + String.valueOf((Object)this.getVisibilityType()) + ", relatedProcessId=" + this.getRelatedProcessId() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessRelation)) {
            return false;
        }
        ProcessRelation other = (ProcessRelation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ProcessRelationRoleType this$roleType = this.getRoleType();
        ProcessRelationRoleType other$roleType = other.getRoleType();
        if (this$roleType == null ? other$roleType != null : !((Object)((Object)this$roleType)).equals((Object)other$roleType)) {
            return false;
        }
        String this$originRole = this.getOriginRole();
        String other$originRole = other.getOriginRole();
        if (this$originRole == null ? other$originRole != null : !this$originRole.equals(other$originRole)) {
            return false;
        }
        String this$targetRole = this.getTargetRole();
        String other$targetRole = other.getTargetRole();
        if (this$targetRole == null ? other$targetRole != null : !this$targetRole.equals(other$targetRole)) {
            return false;
        }
        ProcessRelationRoleVisibility this$visibilityType = this.getVisibilityType();
        ProcessRelationRoleVisibility other$visibilityType = other.getVisibilityType();
        if (this$visibilityType == null ? other$visibilityType != null : !((Object)((Object)this$visibilityType)).equals((Object)other$visibilityType)) {
            return false;
        }
        String this$relatedProcessId = this.getRelatedProcessId();
        String other$relatedProcessId = other.getRelatedProcessId();
        return !(this$relatedProcessId == null ? other$relatedProcessId != null : !this$relatedProcessId.equals(other$relatedProcessId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProcessRelation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ProcessRelationRoleType $roleType = this.getRoleType();
        result = result * 59 + ($roleType == null ? 43 : ((Object)((Object)$roleType)).hashCode());
        String $originRole = this.getOriginRole();
        result = result * 59 + ($originRole == null ? 43 : $originRole.hashCode());
        String $targetRole = this.getTargetRole();
        result = result * 59 + ($targetRole == null ? 43 : $targetRole.hashCode());
        ProcessRelationRoleVisibility $visibilityType = this.getVisibilityType();
        result = result * 59 + ($visibilityType == null ? 43 : ((Object)((Object)$visibilityType)).hashCode());
        String $relatedProcessId = this.getRelatedProcessId();
        result = result * 59 + ($relatedProcessId == null ? 43 : $relatedProcessId.hashCode());
        return result;
    }

    @Generated
    protected ProcessRelation() {
    }

    @Generated
    void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    @Generated
    static class ProcessRelationBuilder {
        @Generated
        private String name;
        @Generated
        private ProcessRelationRoleType roleType;
        @Generated
        private String originRole;
        @Generated
        private String targetRole;
        @Generated
        private ProcessRelationRoleVisibility visibilityTyp;
        @Generated
        private String relatedProcessId;

        @Generated
        ProcessRelationBuilder() {
        }

        @Generated
        ProcessRelationBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        ProcessRelationBuilder roleType(@NonNull ProcessRelationRoleType roleType) {
            if (roleType == null) {
                throw new NullPointerException("roleType is marked non-null but is null");
            }
            this.roleType = roleType;
            return this;
        }

        @Generated
        ProcessRelationBuilder originRole(@NonNull String originRole) {
            if (originRole == null) {
                throw new NullPointerException("originRole is marked non-null but is null");
            }
            this.originRole = originRole;
            return this;
        }

        @Generated
        ProcessRelationBuilder targetRole(@NonNull String targetRole) {
            if (targetRole == null) {
                throw new NullPointerException("targetRole is marked non-null but is null");
            }
            this.targetRole = targetRole;
            return this;
        }

        @Generated
        ProcessRelationBuilder visibilityTyp(@NonNull ProcessRelationRoleVisibility visibilityTyp) {
            if (visibilityTyp == null) {
                throw new NullPointerException("visibilityTyp is marked non-null but is null");
            }
            this.visibilityTyp = visibilityTyp;
            return this;
        }

        @Generated
        ProcessRelationBuilder relatedProcessId(@NonNull String relatedProcessId) {
            if (relatedProcessId == null) {
                throw new NullPointerException("relatedProcessId is marked non-null but is null");
            }
            this.relatedProcessId = relatedProcessId;
            return this;
        }

        @Generated
        ProcessRelation build() {
            return new ProcessRelation(this.name, this.roleType, this.originRole, this.targetRole, this.visibilityTyp, this.relatedProcessId);
        }

        @Generated
        public String toString() {
            return "ProcessRelation.ProcessRelationBuilder(name=" + this.name + ", roleType=" + String.valueOf((Object)this.roleType) + ", originRole=" + this.originRole + ", targetRole=" + this.targetRole + ", visibilityTyp=" + String.valueOf((Object)this.visibilityTyp) + ", relatedProcessId=" + this.relatedProcessId + ")";
        }
    }
}

