/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.message;

import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

@Embeddable
public class MessageData {
    @NotNull
    private String templateName;
    @NotNull
    @Column(name="key_")
    private String key;
    @NotNull
    @Column(name="value_")
    private String value;
    private String role;

    private static MessageData createMessageData(@NonNull String templateName, @NonNull String key, @NonNull String value, String role) {
        if (templateName == null) {
            throw new NullPointerException("templateName is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return new MessageData(templateName, key, value, role);
    }

    public MessageData(String templateName, String key, String value, String role) {
        Objects.requireNonNull(templateName, "Template name is mandatory.");
        Objects.requireNonNull(key, "Key is mandatory.");
        Objects.requireNonNull(value, "Value is mandatory.");
        this.templateName = templateName;
        this.key = key;
        this.value = value;
        this.role = role;
    }

    public MessageData(String templateName, String key, String value) {
        this(templateName, key, value, null);
    }

    public static MessageData from(String templateName, ch.admin.bit.jeap.processcontext.plugin.api.event.MessageData messageData) {
        return new MessageData(templateName, messageData.getKey(), messageData.getValue(), messageData.getRole());
    }

    public static Set<MessageData> from(String templateName, Set<ch.admin.bit.jeap.processcontext.plugin.api.event.MessageData> messageData) {
        return messageData.stream().map(data -> MessageData.from(templateName, data)).collect(Collectors.toSet());
    }

    @Generated
    public static MessageDataBuilder builder() {
        return new MessageDataBuilder();
    }

    @Generated
    protected MessageData() {
    }

    @Generated
    public String getTemplateName() {
        return this.templateName;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public String toString() {
        return "MessageData(templateName=" + this.getTemplateName() + ", key=" + this.getKey() + ", value=" + this.getValue() + ", role=" + this.getRole() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageData)) {
            return false;
        }
        MessageData other = (MessageData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$templateName = this.getTemplateName();
        String other$templateName = other.getTemplateName();
        if (this$templateName == null ? other$templateName != null : !this$templateName.equals(other$templateName)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        return !(this$role == null ? other$role != null : !this$role.equals(other$role));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MessageData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $templateName = this.getTemplateName();
        result = result * 59 + ($templateName == null ? 43 : $templateName.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        return result;
    }

    @Generated
    public static class MessageDataBuilder {
        @Generated
        private String templateName;
        @Generated
        private String key;
        @Generated
        private String value;
        @Generated
        private String role;

        @Generated
        MessageDataBuilder() {
        }

        @Generated
        public MessageDataBuilder templateName(@NonNull String templateName) {
            if (templateName == null) {
                throw new NullPointerException("templateName is marked non-null but is null");
            }
            this.templateName = templateName;
            return this;
        }

        @Generated
        public MessageDataBuilder key(@NonNull String key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
            return this;
        }

        @Generated
        public MessageDataBuilder value(@NonNull String value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            return this;
        }

        @Generated
        public MessageDataBuilder role(String role) {
            this.role = role;
            return this;
        }

        @Generated
        public MessageData build() {
            return MessageData.createMessageData(this.templateName, this.key, this.value, this.role);
        }

        @Generated
        public String toString() {
            return "MessageData.MessageDataBuilder(templateName=" + this.templateName + ", key=" + this.key + ", value=" + this.value + ", role=" + this.role + ")";
        }
    }
}

