/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processinstance;

import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessData;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessDataWrapper;
import ch.admin.bit.jeap.processcontext.domain.processinstance.Relation;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.RelationNodeSelector;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.RelationPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

final class RelationFactory {
    static Collection<Relation> createMatchingRelations(String systemId, RelationPattern relationPattern, ProcessDataWrapper processDataWrapper) {
        Set<RelationNode> objects = RelationFactory.findNodesByPattern(processDataWrapper, relationPattern.getObjectSelector());
        if (objects.isEmpty()) {
            return Set.of();
        }
        Set<RelationNode> subjects = RelationFactory.findNodesByPattern(processDataWrapper, relationPattern.getSubjectSelector());
        if (subjects.isEmpty()) {
            return Set.of();
        }
        return RelationFactory.createRelations(objects, subjects, systemId, relationPattern);
    }

    private static Set<RelationNode> findNodesByPattern(ProcessDataWrapper processDataWrapper, RelationNodeSelector selector) {
        String processDataKey = selector.getProcessDataKey();
        String processDataRole = selector.getProcessDataRole();
        Set<ProcessData> matches = processDataWrapper.findByKeyAndOptionalRole(processDataKey, processDataRole);
        return matches.stream().map(processData -> RelationNode.of(processData, selector)).collect(Collectors.toSet());
    }

    private static Collection<Relation> createRelations(Set<RelationNode> objects, Set<RelationNode> subjects, String systemId, RelationPattern relationPattern) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (RelationNode object : objects) {
            for (RelationNode subject : subjects) {
                if (relationPattern.getJoinType() == null) {
                    relations.add(RelationFactory.createRelation(systemId, relationPattern.getPredicateType(), object, subject, relationPattern.getFeatureFlag()));
                    continue;
                }
                if ("byRole".equals(relationPattern.getJoinType())) {
                    if (object.getRole() == null || !object.getRole().equals(subject.getRole())) continue;
                    relations.add(RelationFactory.createRelation(systemId, relationPattern.getPredicateType(), object, subject, relationPattern.getFeatureFlag()));
                    continue;
                }
                if (!"byValue".equals(relationPattern.getJoinType()) || object.getId() == null || !object.getId().equals(subject.getId())) continue;
                relations.add(RelationFactory.createRelation(systemId, relationPattern.getPredicateType(), object, subject, relationPattern.getFeatureFlag()));
            }
        }
        return relations;
    }

    private static Relation createRelation(String systemId, String predicateType, RelationNode object, RelationNode subject, String featureFlag) {
        return Relation.builder().systemId(systemId).subjectType(subject.getType()).subjectId(subject.getId()).objectType(object.getType()).objectId(object.getId()).predicateType(predicateType).featureFlag(featureFlag).build();
    }

    @Generated
    private RelationFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class RelationNode {
        private final String type;
        private final String id;
        private final String role;

        static RelationNode of(ProcessData pd, RelationNodeSelector selector) {
            return new RelationNode(selector.getType(), pd.getValue(), pd.getRole());
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getRole() {
            return this.role;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelationNode)) {
                return false;
            }
            RelationNode other = (RelationNode)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$role = this.getRole();
            String other$role = other.getRole();
            return !(this$role == null ? other$role != null : !this$role.equals(other$role));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $role = this.getRole();
            result = result * 59 + ($role == null ? 43 : $role.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "RelationFactory.RelationNode(type=" + this.getType() + ", id=" + this.getId() + ", role=" + this.getRole() + ")";
        }

        @Generated
        private RelationNode(String type, String id, String role) {
            this.type = type;
            this.id = id;
            this.role = role;
        }
    }
}

