/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processevent;

import ch.admin.bit.jeap.processcontext.domain.MutableDomainEntity;
import ch.admin.bit.jeap.processcontext.domain.processevent.EventType;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
public class ProcessEvent
extends MutableDomainEntity {
    @Id
    @NonNull
    private UUID id;
    @NonNull
    private String originProcessId;
    @Enumerated(value=EnumType.STRING)
    @NonNull
    private EventType eventType;
    private String name;

    static ProcessEvent createProcessStarted(String originProcessId) {
        return new ProcessEvent(Generators.timeBasedEpochGenerator().generate(), originProcessId, EventType.PROCESS_STARTED, null);
    }

    static ProcessEvent createProcessCompleted(String originProcessId) {
        return new ProcessEvent(Generators.timeBasedEpochGenerator().generate(), originProcessId, EventType.PROCESS_COMPLETED, null);
    }

    static ProcessEvent createMilestoneReached(String originProcessId, String milestoneName) {
        return new ProcessEvent(Generators.timeBasedEpochGenerator().generate(), originProcessId, EventType.MILESTONE_REACHED, milestoneName);
    }

    public static ProcessEvent createRelationAdded(String originProcessId, UUID idempotenceId) {
        return new ProcessEvent(Generators.timeBasedEpochGenerator().generate(), originProcessId, EventType.RELATION_ADDED, idempotenceId.toString());
    }

    public static ProcessEvent createSnapshotCreated(String originProcessId, String snapshotVersion) {
        return new ProcessEvent(Generators.timeBasedEpochGenerator().generate(), originProcessId, EventType.SNAPSHOT_CREATED, snapshotVersion);
    }

    public static ProcessEvent createRelationProhibited(String originProcessId, UUID idempotenceId) {
        return new ProcessEvent(Generators.timeBasedEpochGenerator().generate(), originProcessId, EventType.RELATION_PROHIBITED, idempotenceId.toString());
    }

    @Generated
    protected ProcessEvent() {
    }

    @Generated
    private ProcessEvent(@NonNull UUID id, @NonNull String originProcessId, @NonNull EventType eventType, String name) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (originProcessId == null) {
            throw new NullPointerException("originProcessId is marked non-null but is null");
        }
        if (eventType == null) {
            throw new NullPointerException("eventType is marked non-null but is null");
        }
        this.id = id;
        this.originProcessId = originProcessId;
        this.eventType = eventType;
        this.name = name;
    }

    @Generated
    public String toString() {
        return "ProcessEvent(id=" + String.valueOf(this.id) + ", originProcessId=" + this.originProcessId + ", eventType=" + String.valueOf((Object)this.getEventType()) + ", name=" + this.getName() + ")";
    }

    @NonNull
    @Generated
    public EventType getEventType() {
        return this.eventType;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

