/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processinstance;

import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstance;
import com.fasterxml.uuid.Generators;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.ZonedDateTime;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;

@Entity
@Table(name="process_instance_relations")
public class Relation {
    @Id
    @NotNull
    private UUID id = Generators.timeBasedEpochGenerator().generate();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="process_instance_id")
    private ProcessInstance processInstance;
    @NotNull
    private String systemId;
    @NotNull
    private String subjectType;
    @NotNull
    private String subjectId;
    @NotNull
    private String objectType;
    @NotNull
    private String objectId;
    @NotNull
    private String predicateType;
    private ZonedDateTime createdAt;
    private UUID idempotenceId;
    private String featureFlag;

    private Relation(@NonNull String systemId, @NonNull String subjectType, @NonNull String subjectId, @NonNull String objectType, @NonNull String objectId, @NonNull String predicateType, String featureFlag) {
        if (systemId == null) {
            throw new NullPointerException("systemId is marked non-null but is null");
        }
        if (subjectType == null) {
            throw new NullPointerException("subjectType is marked non-null but is null");
        }
        if (subjectId == null) {
            throw new NullPointerException("subjectId is marked non-null but is null");
        }
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        if (objectId == null) {
            throw new NullPointerException("objectId is marked non-null but is null");
        }
        if (predicateType == null) {
            throw new NullPointerException("predicateType is marked non-null but is null");
        }
        this.systemId = systemId;
        this.subjectType = subjectType;
        this.subjectId = subjectId;
        this.objectType = objectType;
        this.objectId = objectId;
        this.predicateType = predicateType;
        this.featureFlag = featureFlag;
    }

    void onPrePersist() {
        if (this.idempotenceId != null || this.createdAt != null) {
            throw new IllegalStateException("Modifying idempotenceId/createdAt not allowed for persistent Relation entity");
        }
        this.idempotenceId = Generators.timeBasedEpochGenerator().generate();
        this.createdAt = ZonedDateTime.now();
    }

    @Generated
    static RelationBuilder builder() {
        return new RelationBuilder();
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    @Generated
    public String getSystemId() {
        return this.systemId;
    }

    @Generated
    public String getSubjectType() {
        return this.subjectType;
    }

    @Generated
    public String getSubjectId() {
        return this.subjectId;
    }

    @Generated
    public String getObjectType() {
        return this.objectType;
    }

    @Generated
    public String getObjectId() {
        return this.objectId;
    }

    @Generated
    public String getPredicateType() {
        return this.predicateType;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public UUID getIdempotenceId() {
        return this.idempotenceId;
    }

    @Generated
    public String getFeatureFlag() {
        return this.featureFlag;
    }

    @Generated
    public String toString() {
        return "Relation(id=" + String.valueOf(this.getId()) + ", systemId=" + this.getSystemId() + ", subjectType=" + this.getSubjectType() + ", subjectId=" + this.getSubjectId() + ", objectType=" + this.getObjectType() + ", objectId=" + this.getObjectId() + ", predicateType=" + this.getPredicateType() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", idempotenceId=" + String.valueOf(this.getIdempotenceId()) + ", featureFlag=" + this.getFeatureFlag() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Relation)) {
            return false;
        }
        Relation other = (Relation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$systemId = this.getSystemId();
        String other$systemId = other.getSystemId();
        if (this$systemId == null ? other$systemId != null : !this$systemId.equals(other$systemId)) {
            return false;
        }
        String this$subjectType = this.getSubjectType();
        String other$subjectType = other.getSubjectType();
        if (this$subjectType == null ? other$subjectType != null : !this$subjectType.equals(other$subjectType)) {
            return false;
        }
        String this$subjectId = this.getSubjectId();
        String other$subjectId = other.getSubjectId();
        if (this$subjectId == null ? other$subjectId != null : !this$subjectId.equals(other$subjectId)) {
            return false;
        }
        String this$objectType = this.getObjectType();
        String other$objectType = other.getObjectType();
        if (this$objectType == null ? other$objectType != null : !this$objectType.equals(other$objectType)) {
            return false;
        }
        String this$objectId = this.getObjectId();
        String other$objectId = other.getObjectId();
        if (this$objectId == null ? other$objectId != null : !this$objectId.equals(other$objectId)) {
            return false;
        }
        String this$predicateType = this.getPredicateType();
        String other$predicateType = other.getPredicateType();
        if (this$predicateType == null ? other$predicateType != null : !this$predicateType.equals(other$predicateType)) {
            return false;
        }
        String this$featureFlag = this.getFeatureFlag();
        String other$featureFlag = other.getFeatureFlag();
        return !(this$featureFlag == null ? other$featureFlag != null : !this$featureFlag.equals(other$featureFlag));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Relation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $systemId = this.getSystemId();
        result = result * 59 + ($systemId == null ? 43 : $systemId.hashCode());
        String $subjectType = this.getSubjectType();
        result = result * 59 + ($subjectType == null ? 43 : $subjectType.hashCode());
        String $subjectId = this.getSubjectId();
        result = result * 59 + ($subjectId == null ? 43 : $subjectId.hashCode());
        String $objectType = this.getObjectType();
        result = result * 59 + ($objectType == null ? 43 : $objectType.hashCode());
        String $objectId = this.getObjectId();
        result = result * 59 + ($objectId == null ? 43 : $objectId.hashCode());
        String $predicateType = this.getPredicateType();
        result = result * 59 + ($predicateType == null ? 43 : $predicateType.hashCode());
        String $featureFlag = this.getFeatureFlag();
        result = result * 59 + ($featureFlag == null ? 43 : $featureFlag.hashCode());
        return result;
    }

    @Generated
    protected Relation() {
    }

    @Generated
    void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    @Generated
    static class RelationBuilder {
        @Generated
        private String systemId;
        @Generated
        private String subjectType;
        @Generated
        private String subjectId;
        @Generated
        private String objectType;
        @Generated
        private String objectId;
        @Generated
        private String predicateType;
        @Generated
        private String featureFlag;

        @Generated
        RelationBuilder() {
        }

        @Generated
        RelationBuilder systemId(@NonNull String systemId) {
            if (systemId == null) {
                throw new NullPointerException("systemId is marked non-null but is null");
            }
            this.systemId = systemId;
            return this;
        }

        @Generated
        RelationBuilder subjectType(@NonNull String subjectType) {
            if (subjectType == null) {
                throw new NullPointerException("subjectType is marked non-null but is null");
            }
            this.subjectType = subjectType;
            return this;
        }

        @Generated
        RelationBuilder subjectId(@NonNull String subjectId) {
            if (subjectId == null) {
                throw new NullPointerException("subjectId is marked non-null but is null");
            }
            this.subjectId = subjectId;
            return this;
        }

        @Generated
        RelationBuilder objectType(@NonNull String objectType) {
            if (objectType == null) {
                throw new NullPointerException("objectType is marked non-null but is null");
            }
            this.objectType = objectType;
            return this;
        }

        @Generated
        RelationBuilder objectId(@NonNull String objectId) {
            if (objectId == null) {
                throw new NullPointerException("objectId is marked non-null but is null");
            }
            this.objectId = objectId;
            return this;
        }

        @Generated
        RelationBuilder predicateType(@NonNull String predicateType) {
            if (predicateType == null) {
                throw new NullPointerException("predicateType is marked non-null but is null");
            }
            this.predicateType = predicateType;
            return this;
        }

        @Generated
        RelationBuilder featureFlag(String featureFlag) {
            this.featureFlag = featureFlag;
            return this;
        }

        @Generated
        Relation build() {
            return new Relation(this.systemId, this.subjectType, this.subjectId, this.objectType, this.objectId, this.predicateType, this.featureFlag);
        }

        @Generated
        public String toString() {
            return "Relation.RelationBuilder(systemId=" + this.systemId + ", subjectType=" + this.subjectType + ", subjectId=" + this.subjectId + ", objectType=" + this.objectType + ", objectId=" + this.objectId + ", predicateType=" + this.predicateType + ", featureFlag=" + this.featureFlag + ")";
        }
    }
}

