/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processinstance.migration;

import ch.admin.bit.jeap.processcontext.domain.port.InternalMessageProducer;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstanceRepository;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessTemplate;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessTemplateRepository;
import java.time.ZonedDateTime;
import lombok.Generated;
import net.logstash.logback.argument.StructuredArguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ProcessInstanceMigrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceMigrationService.class);
    private final ProcessTemplateRepository processTemplateRepository;
    private final ProcessInstanceRepository processInstanceRepository;
    private final InternalMessageProducer internalMessageProducer;

    public void initializeProcessTemplateHashes() {
        this.processTemplateRepository.getAllTemplates().forEach(this.processInstanceRepository::setHashForTemplateIfNull);
    }

    @Async
    public void triggerMigrationForModifiedTemplates(ZonedDateTime lastModifiedAfter) {
        this.processTemplateRepository.getAllTemplates().forEach(template -> this.triggerMigrationForTemplateIfModified((ProcessTemplate)template, lastModifiedAfter));
    }

    private void triggerMigrationForTemplateIfModified(ProcessTemplate template, ZonedDateTime lastModifiedAfter) {
        Pageable pageable = Pageable.ofSize((int)10);
        while (pageable.isPaged()) {
            Slice<String> changedTemplateOriginProcessIds = this.processInstanceRepository.findUncompletedProcessInstanceOriginIdsByTemplateHashChanged(lastModifiedAfter, template, pageable);
            changedTemplateOriginProcessIds.forEach(this::sendProcessOutdatedEvent);
            pageable = changedTemplateOriginProcessIds.nextPageable();
        }
    }

    private void sendProcessOutdatedEvent(String originProcessId) {
        log.info("Triggering process outdated event due to changed template for process {}", (Object)StructuredArguments.keyValue((String)"originProcessId", (Object)originProcessId));
        this.internalMessageProducer.produceProcessContextOutdatedEventSynchronously(originProcessId);
    }

    @Generated
    public ProcessInstanceMigrationService(ProcessTemplateRepository processTemplateRepository, ProcessInstanceRepository processInstanceRepository, InternalMessageProducer internalMessageProducer) {
        this.processTemplateRepository = processTemplateRepository;
        this.processInstanceRepository = processInstanceRepository;
        this.internalMessageProducer = internalMessageProducer;
    }
}

