/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.housekeeping;

import ch.admin.bit.jeap.processcontext.domain.housekeeping.HouseKeepingConfigProperties;
import ch.admin.bit.jeap.processcontext.domain.message.MessageRepository;
import ch.admin.bit.jeap.processcontext.domain.processevent.ProcessEventRepository;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstanceQueryResult;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstanceRepository;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessState;
import ch.admin.bit.jeap.processcontext.domain.processupdate.ProcessUpdateRepository;
import io.micrometer.core.annotation.Timed;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class HouseKeepingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HouseKeepingService.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy - HH:mm:ss Z");
    private final ProcessInstanceRepository processInstanceRepository;
    private final ProcessUpdateRepository processUpdateRepository;
    private final ProcessEventRepository processEventRepository;
    private final MessageRepository messageRepository;
    private final HouseKeepingConfigProperties configProperties;
    private final TransactionTemplate transactionTemplate;
    private final Pageable pageable;

    public HouseKeepingService(ProcessInstanceRepository processInstanceRepository, ProcessUpdateRepository processUpdateRepository, ProcessEventRepository processEventRepository, MessageRepository messageRepository, HouseKeepingConfigProperties configProperties, PlatformTransactionManager transactionManager) {
        this.processInstanceRepository = processInstanceRepository;
        this.processUpdateRepository = processUpdateRepository;
        this.processEventRepository = processEventRepository;
        this.messageRepository = messageRepository;
        this.configProperties = configProperties;
        this.pageable = Pageable.ofSize((int)configProperties.getPageSize());
        this.transactionTemplate = new TransactionTemplate(transactionManager);
        this.transactionTemplate.setPropagationBehavior(3);
    }

    @Timed(value="jeap_pcs_housekeeping_cleanup", percentiles={0.5, 0.8, 0.95, 0.99})
    public void cleanup() {
        this.deleteProcessInstances(ProcessState.COMPLETED, this.configProperties.getCompletedProcessInstancesMaxAge());
        this.deleteProcessInstances(ProcessState.STARTED, this.configProperties.getStartedProcessInstancesMaxAge());
        this.deleteMessagesWithoutProcessCorrelation(this.configProperties.getEventsMaxAge());
        this.deleteUnhandledProcessUpdates(this.configProperties.getProcessUpdateMaxAge());
    }

    protected void deleteProcessInstances(ProcessState processState, Duration maxAge) {
        ZonedDateTime olderThan = ZonedDateTime.now().minus(maxAge);
        log.info("Housekeeping: find processInstances which are older than {} ({}) with processState '{}'", new Object[]{maxAge, olderThan.format(DATE_TIME_FORMATTER), processState});
        this.executeInTransactionPerPage(() -> this.deleteProcessInstancePage(processState, olderThan));
    }

    private boolean deleteProcessInstancePage(ProcessState processState, ZonedDateTime olderThan) {
        Slice<ProcessInstanceQueryResult> resultPage = this.processInstanceRepository.findProcessInstances(processState, olderThan, this.pageable);
        log.info("Housekeeping: found {} processInstances", (Object)resultPage.getNumberOfElements());
        Set processInstances = resultPage.toSet();
        this.deleteProcessInstances(processInstances.stream().map(ProcessInstanceQueryResult::getId).collect(Collectors.toSet()));
        Set<String> originProcessIds = processInstances.stream().map(ProcessInstanceQueryResult::getOriginProcessId).collect(Collectors.toSet());
        this.deleteProcessUpdates(originProcessIds);
        this.deleteProcessEvents(originProcessIds);
        return resultPage.hasNext();
    }

    private void deleteProcessInstances(Set<UUID> ids) {
        log.info("Housekeeping: delete processInstances...");
        if (!ids.isEmpty()) {
            this.processInstanceRepository.deleteAllById(ids);
            log.info("Housekeeping: deleted {} processInstances", (Object)ids.size());
        }
    }

    private void deleteProcessUpdates(Set<String> originProcessIds) {
        log.info("Housekeeping: delete processUpdates...");
        long count = this.processUpdateRepository.countAllByOriginProcessIdIn(originProcessIds);
        this.processUpdateRepository.deleteAllByOriginProcessIdIn(originProcessIds);
        log.info("Housekeeping: deleted {} processUpdates", (Object)count);
    }

    private void deleteProcessEvents(Set<String> originProcessIds) {
        log.info("Housekeeping: delete processEvents...");
        long count = this.processEventRepository.deleteAllByOriginProcessIdIn(originProcessIds);
        log.info("Housekeeping: deleted {} processEvents", (Object)count);
    }

    protected void deleteMessagesWithoutProcessCorrelation(Duration maxAge) {
        ZonedDateTime olderThan = ZonedDateTime.now().minus(maxAge);
        log.info("Housekeeping: find messages which are older than {} ({}) without process correlation", (Object)maxAge, (Object)olderThan.format(DATE_TIME_FORMATTER));
        this.executeInTransactionPerPage(() -> this.deleteMessagesWithoutProcessCorrelationPage(olderThan));
    }

    private boolean deleteMessagesWithoutProcessCorrelationPage(ZonedDateTime olderThan) {
        Slice<UUID> resultPage = this.messageRepository.findMessagesWithoutProcessCorrelation(olderThan, this.pageable);
        log.info("Housekeeping: found {} messages to delete", (Object)resultPage.getNumberOfElements());
        Set messageIds = resultPage.toSet();
        this.messageRepository.deleteMessageDataByMessageIds(messageIds);
        this.messageRepository.deleteMessageUserDataByMessageIds(messageIds);
        this.messageRepository.deleteOriginTaskIdByMessageIds(messageIds);
        this.messageRepository.deleteMessageByIds(messageIds);
        log.info("Housekeeping: deleted {} messages", (Object)messageIds.size());
        return resultPage.hasNext();
    }

    protected void deleteUnhandledProcessUpdates(Duration maxAge) {
        ZonedDateTime olderThan = ZonedDateTime.now().minus(maxAge);
        log.info("Housekeeping: find process updates which are older than {} ({}) where handled = false", (Object)maxAge, (Object)olderThan.format(DATE_TIME_FORMATTER));
        this.executeInTransactionPerPage(() -> this.deleteUnhandledProcessUpdatesPage(olderThan));
    }

    private boolean deleteUnhandledProcessUpdatesPage(ZonedDateTime olderThan) {
        Slice<UUID> resultPage = this.processUpdateRepository.findProcessUpdateIdWithHandledFalse(olderThan, this.pageable);
        Set processUpdateIds = resultPage.toSet();
        this.processUpdateRepository.deleteAllById(processUpdateIds);
        log.info("Housekeeping: deleted {} process updates", (Object)processUpdateIds.size());
        return resultPage.hasNext();
    }

    private void executeInTransactionPerPage(Supplier<Boolean> callback) {
        boolean hasMorePages;
        for (int pages = 0; pages < this.configProperties.getMaxPages() && (hasMorePages = ((Boolean)this.transactionTemplate.execute(status -> (Boolean)callback.get())).booleanValue()); ++pages) {
        }
    }
}

