/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.domain.processrelation;

import ch.admin.bit.jeap.processcontext.domain.TranslateService;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstance;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstanceRepository;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessInstanceSummary;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessRelation;
import ch.admin.bit.jeap.processcontext.domain.processinstance.ProcessRelationRepository;
import ch.admin.bit.jeap.processcontext.domain.processrelation.ProcessRelationView;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessRelationRoleType;
import ch.admin.bit.jeap.processcontext.domain.processtemplate.ProcessRelationRoleVisibility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessRelationsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessRelationsService.class);
    private final ProcessRelationRepository processRelationRepository;
    private final ProcessInstanceRepository processInstanceRepository;
    private final TranslateService translateService;

    public List<ProcessRelationView> createProcessRelations(ProcessInstance processInstance) {
        Set<ProcessRelation> processRelations = processInstance.getProcessRelations();
        ArrayList<ProcessRelationView> processRelationViewList = new ArrayList<ProcessRelationView>(processRelations.stream().filter(processRelation -> processRelation.getVisibilityType() != ProcessRelationRoleVisibility.TARGET).map(this::evaluateDirectProcessRelation).toList());
        List<ProcessRelationView> externalList = this.findExternalProcessRelations(processInstance.getOriginProcessId());
        processRelationViewList.addAll(externalList);
        return processRelationViewList;
    }

    private List<ProcessRelationView> findExternalProcessRelations(String originProcessId) {
        List<ProcessRelation> processRelationList = this.processRelationRepository.findByRelatedProcessId(originProcessId);
        return processRelationList.stream().filter(processRelation -> processRelation.getVisibilityType() != ProcessRelationRoleVisibility.ORIGIN).map(this::createExternalProcessRelationView).toList();
    }

    private ProcessRelationView evaluateDirectProcessRelation(ProcessRelation originProcessRelation) {
        String processTemplateName = originProcessRelation.getProcessInstance().getProcessTemplateName();
        Optional<ProcessInstanceSummary> processInstanceSummaryOptional = this.processInstanceRepository.findProcessInstanceSummaryByOriginProcessId(originProcessRelation.getRelatedProcessId());
        Map<String, String> relationTextI18N = originProcessRelation.getRoleType() == ProcessRelationRoleType.ORIGIN ? this.translateService.translateProcessRelationTargetRole(processTemplateName, originProcessRelation.getName()) : this.translateService.translateProcessRelationOriginRole(processTemplateName, originProcessRelation.getName());
        if (processInstanceSummaryOptional.isPresent()) {
            ProcessInstanceSummary instanceSummary = processInstanceSummaryOptional.get();
            return ProcessRelationView.builder().relationName(originProcessRelation.getName()).originRole(originProcessRelation.getOriginRole()).targetRole(originProcessRelation.getTargetRole()).processTemplateName(instanceSummary.getProcessTemplateName()).relationRole(originProcessRelation.getRoleType()).processId(instanceSummary.getOriginProcessId()).processName(this.translateService.translateProcessTemplateName(instanceSummary.getProcessTemplateName())).processState(instanceSummary.getState().toString()).relation(relationTextI18N).build();
        }
        return ProcessRelationView.builder().relationName(originProcessRelation.getName()).originRole(originProcessRelation.getOriginRole()).targetRole(originProcessRelation.getTargetRole()).processTemplateName("unknown").relationRole(originProcessRelation.getRoleType()).processId(originProcessRelation.getRelatedProcessId()).processName(TranslateService.noTranslation("-")).relation(relationTextI18N).build();
    }

    private ProcessRelationView createExternalProcessRelationView(ProcessRelation processRelation) {
        ProcessInstance processInstance = processRelation.getProcessInstance();
        String processTemplateName = processInstance.getProcessTemplateName();
        Map<String, String> relationTextI18N = processRelation.getRoleType() == ProcessRelationRoleType.ORIGIN ? this.translateService.translateProcessRelationOriginRole(processTemplateName, processRelation.getName()) : this.translateService.translateProcessRelationTargetRole(processTemplateName, processRelation.getName());
        return ProcessRelationView.builder().relationName(processRelation.getName()).originRole(processRelation.getOriginRole()).targetRole(processRelation.getTargetRole()).processTemplateName(processTemplateName).relationRole(processRelation.getRoleType()).processId(processInstance.getOriginProcessId()).processName(this.translateService.translateProcessTemplateName(processTemplateName)).processState(processInstance.getState().name()).relation(relationTextI18N).build();
    }

    @Generated
    public ProcessRelationsService(ProcessRelationRepository processRelationRepository, ProcessInstanceRepository processInstanceRepository, TranslateService translateService) {
        this.processRelationRepository = processRelationRepository;
        this.processInstanceRepository = processInstanceRepository;
        this.translateService = translateService;
    }
}

