/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.plugin.api.context;

import ch.admin.bit.jeap.processcontext.plugin.api.context.Event;
import ch.admin.bit.jeap.processcontext.plugin.api.context.Message;
import ch.admin.bit.jeap.processcontext.plugin.api.context.ProcessCompletion;
import ch.admin.bit.jeap.processcontext.plugin.api.context.ProcessState;
import ch.admin.bit.jeap.processcontext.plugin.api.context.Task;
import ch.admin.bit.jeap.processcontext.plugin.api.context.TaskState;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class ProcessContext {
    private final String originProcessId;
    private final String processName;
    private final ProcessState processState;
    private final ProcessCompletion processCompletion;
    private final List<Task> tasks;
    private final List<Message> messages;
    private final Map<String, List<Task>> tasksByName;
    private final Map<String, List<Message>> messagesByName;

    private ProcessContext(@NonNull String originProcessId, @NonNull String processName, @NonNull ProcessState processState, @NonNull List<Task> tasks, @NonNull List<Message> messages, ProcessCompletion processCompletion) {
        if (originProcessId == null) {
            throw new NullPointerException("originProcessId is marked non-null but is null");
        }
        if (processName == null) {
            throw new NullPointerException("processName is marked non-null but is null");
        }
        if (processState == null) {
            throw new NullPointerException("processState is marked non-null but is null");
        }
        if (tasks == null) {
            throw new NullPointerException("tasks is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.originProcessId = originProcessId;
        this.processName = processName;
        this.processState = processState;
        this.tasks = tasks;
        this.messages = messages;
        if (processState == ProcessState.COMPLETED && processCompletion == null) {
            throw new IllegalArgumentException("Process completion must be provided for a process in completed state.");
        }
        this.processCompletion = processCompletion;
        this.tasksByName = tasks.stream().collect(Collectors.groupingBy(task -> task.getType().getName()));
        this.messagesByName = messages.stream().collect(Collectors.groupingBy(Message::getName));
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    public List<Event> getEvents() {
        return this.messages.stream().map(message -> new Event(message.getName(), message.getRelatedOriginTaskIds(), message.getMessageData())).toList();
    }

    public boolean isTasksInState(String name, TaskState expectedState) {
        List<Task> tasksByNameRetrieved = this.getTasksByName(name);
        return !tasksByNameRetrieved.isEmpty() && tasksByNameRetrieved.stream().allMatch(task -> task.getState() == expectedState);
    }

    public List<Task> getTasksByName(String name) {
        return this.tasksByName.getOrDefault(name, Collections.emptyList());
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    public List<Event> getEventsByName(String name) {
        return this.messagesByName.getOrDefault(name, List.of()).stream().map(message -> new Event(message.getName(), message.getRelatedOriginTaskIds(), message.getMessageData())).toList();
    }

    public Optional<Task> getTaskById(String taskId) {
        return this.tasks.stream().filter(task -> task.getId().equals(taskId)).findFirst();
    }

    public List<Message> getMessagesByName(String messageName) {
        return this.messagesByName.getOrDefault(messageName, List.of());
    }

    @Generated
    public static ProcessContextBuilder builder() {
        return new ProcessContextBuilder();
    }

    @Generated
    public String getOriginProcessId() {
        return this.originProcessId;
    }

    @Generated
    public String getProcessName() {
        return this.processName;
    }

    @Generated
    public ProcessState getProcessState() {
        return this.processState;
    }

    @Generated
    public ProcessCompletion getProcessCompletion() {
        return this.processCompletion;
    }

    @Generated
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Generated
    public List<Message> getMessages() {
        return this.messages;
    }

    @Generated
    public static class ProcessContextBuilder {
        @Generated
        private String originProcessId;
        @Generated
        private String processName;
        @Generated
        private ProcessState processState;
        @Generated
        private List<Task> tasks;
        @Generated
        private List<Message> messages;
        @Generated
        private ProcessCompletion processCompletion;

        @Generated
        ProcessContextBuilder() {
        }

        @Generated
        public ProcessContextBuilder originProcessId(@NonNull String originProcessId) {
            if (originProcessId == null) {
                throw new NullPointerException("originProcessId is marked non-null but is null");
            }
            this.originProcessId = originProcessId;
            return this;
        }

        @Generated
        public ProcessContextBuilder processName(@NonNull String processName) {
            if (processName == null) {
                throw new NullPointerException("processName is marked non-null but is null");
            }
            this.processName = processName;
            return this;
        }

        @Generated
        public ProcessContextBuilder processState(@NonNull ProcessState processState) {
            if (processState == null) {
                throw new NullPointerException("processState is marked non-null but is null");
            }
            this.processState = processState;
            return this;
        }

        @Generated
        public ProcessContextBuilder tasks(@NonNull List<Task> tasks) {
            if (tasks == null) {
                throw new NullPointerException("tasks is marked non-null but is null");
            }
            this.tasks = tasks;
            return this;
        }

        @Generated
        public ProcessContextBuilder messages(@NonNull List<Message> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
            return this;
        }

        @Generated
        public ProcessContextBuilder processCompletion(ProcessCompletion processCompletion) {
            this.processCompletion = processCompletion;
            return this;
        }

        @Generated
        public ProcessContext build() {
            return new ProcessContext(this.originProcessId, this.processName, this.processState, this.tasks, this.messages, this.processCompletion);
        }

        @Generated
        public String toString() {
            return "ProcessContext.ProcessContextBuilder(originProcessId=" + this.originProcessId + ", processName=" + this.processName + ", processState=" + String.valueOf((Object)this.processState) + ", tasks=" + String.valueOf(this.tasks) + ", messages=" + String.valueOf(this.messages) + ", processCompletion=" + String.valueOf(this.processCompletion) + ")";
        }
    }
}

