/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.migration;

import ch.admin.bit.jeap.processcontext.domain.processinstance.migration.ProcessInstanceMigrationService;
import jakarta.annotation.PostConstruct;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
class MigrationInitializerService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationInitializerService.class);
    @Value(value="${jeap.processcontext.template.migration.max-modified-at-age-days:180}")
    int maxModifiedAtAgeDays;
    private final ProcessInstanceMigrationService processInstanceMigrationService;

    @PostConstruct
    public void triggerMigrationTasks() {
        log.info("Setting initial template hash value");
        this.processInstanceMigrationService.initializeProcessTemplateHashes();
        log.info("Triggering process instance migrations if templates have been modified");
        ZonedDateTime lastModifiedAfter = ZonedDateTime.now().minusDays(this.maxModifiedAtAgeDays);
        this.processInstanceMigrationService.triggerMigrationForModifiedTemplates(lastModifiedAfter);
    }

    @Generated
    public MigrationInitializerService(ProcessInstanceMigrationService processInstanceMigrationService) {
        this.processInstanceMigrationService = processInstanceMigrationService;
    }
}

