/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.processcontext.ui.configuration;

import ch.admin.bit.jeap.processcontext.ui.configuration.ConfigurationDTO;
import ch.admin.bit.jeap.processcontext.ui.configuration.FrontendConfigProperties;
import ch.admin.bit.jeap.processcontext.ui.configuration.LogDeepLinkProperties;
import ch.admin.bit.jeap.processcontext.ui.configuration.VersionDetector;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/configuration"})
class ConfigurationController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigurationController.class);
    private final FrontendConfigProperties frontendConfigProperties;
    private final LogDeepLinkProperties logDeepLinkProperties;

    @GetMapping
    public ConfigurationDTO getConfiguration() {
        return ConfigurationDTO.builder().applicationUrl(this.frontendConfigProperties.getApplicationUrl().toString()).pamsEnvironment(this.frontendConfigProperties.getPamsEnvironment()).authority(this.frontendConfigProperties.getStsServer().toString()).redirectUrl(this.frontendConfigProperties.getApplicationUrl().toString()).logoutRedirectUri(this.frontendConfigProperties.getLogoutRedirectUri().toString()).mockPams(this.frontendConfigProperties.isMockPams()).tokenAwarePatterns(this.frontendConfigProperties.getTokenAwarePattern()).useAutoLogin(this.frontendConfigProperties.isAutoLogin()).clientId(this.frontendConfigProperties.getClientId()).silentRenew(this.frontendConfigProperties.isSilentRenew()).systemName(this.frontendConfigProperties.getSystemName()).renewUserInfoAfterTokenRenew(this.frontendConfigProperties.isRenewUserInfoAfterTokenRenew()).build();
    }

    @Schema(description="Returns the Version")
    @GetMapping(value={"/version"})
    public String getVersion() {
        VersionDetector versionDetector = new VersionDetector();
        return versionDetector.getVersion();
    }

    @Schema(description="Returns the custom Log deeplink template")
    @GetMapping(value={"/log-deeplink"})
    public String getLogDeepLink() {
        return this.logDeepLinkProperties.getBaseUrl();
    }

    @Generated
    public ConfigurationController(FrontendConfigProperties frontendConfigProperties, LogDeepLinkProperties logDeepLinkProperties) {
        this.frontendConfigProperties = frontendConfigProperties;
        this.logDeepLinkProperties = logDeepLinkProperties;
    }
}

