/*
 * Decompiled with CFR 0.152.
 */
package ch.admin.bit.jeap.reaction.observer.core.domain;

import ch.admin.bit.jeap.reaction.observer.core.domain.listener.ReactionIdentifiedListener;
import ch.admin.bit.jeap.reaction.observer.core.domain.model.Reaction;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactionObserverService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactionObserverService.class);
    static final int MAX_REACTION_COUNT = 4096;
    private static boolean warningLogged = false;
    private final ReactionIdentifiedListener reactionIdentifiedListener;
    private volatile Map<String, AtomicInteger> countByReactionId = new ConcurrentHashMap<String, AtomicInteger>();
    private final Set<String> identifiedReactions = ConcurrentHashMap.newKeySet();

    public ReactionObserverService(ReactionIdentifiedListener reactionIdentifiedListener) {
        this.reactionIdentifiedListener = reactionIdentifiedListener;
    }

    public void reactionObserved(Reaction reaction) {
        log.trace("Reaction observed: {}", (Object)reaction);
        try {
            this.identifyReaction(reaction);
            this.countReaction(reaction);
        }
        catch (Exception e) {
            log.warn("Error observing reaction: {}", (Object)reaction, (Object)e);
        }
    }

    private void identifyReaction(Reaction reaction) {
        if (this.identifiedReactions.size() >= 4096) {
            ReactionObserverService.logLimitWarningOnce();
            return;
        }
        if (this.identifiedReactions.add(reaction.id())) {
            log.trace("New reaction identified: {}", (Object)reaction);
            this.reactionIdentifiedListener.onReactionIdentified(reaction);
        }
    }

    public Map<String, AtomicInteger> getAndClearCountByReactionId() {
        Map<String, AtomicInteger> counts = this.countByReactionId;
        this.countByReactionId = new ConcurrentHashMap<String, AtomicInteger>();
        return counts;
    }

    private void countReaction(Reaction reaction) {
        if (this.countByReactionId.size() >= 4096) {
            ReactionObserverService.logLimitWarningOnce();
            return;
        }
        this.countByReactionId.computeIfAbsent(reaction.id(), k -> new AtomicInteger()).incrementAndGet();
    }

    private static void logLimitWarningOnce() {
        if (!warningLogged) {
            log.warn("Maximum reaction count reached ({}). Not identifying new reactions.", (Object)4096);
            warningLogged = true;
        }
    }
}

